% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-miss-var.R
\name{gg_miss_var}
\alias{gg_miss_var}
\title{Plot the number of missings for each variable}
\usage{
gg_miss_var(x, facet, show_pct = FALSE)
}
\arguments{
\item{x}{a dataframe}

\item{facet}{(optional) bare variable name, if you want to create a faceted plot.}

\item{show_pct}{logical shows the number of missings (default), but if set to
TRUE, it will display the proportion of missings.}
}
\value{
a ggplot object depicting the number of missings in a given column
}
\description{
This is a visual analogue to \code{miss_var_summary}. It draws a ggplot of the
number of missings in each variable, ordered to show which variables have
the most missing data. A default minimal theme is used, which can be
customised as normal for ggplot.
}
\examples{

gg_miss_var(airquality)
\dontrun{
library(ggplot2)
gg_miss_var(airquality) + labs(y = "Look at all the missing ones")
gg_miss_var(airquality, Month)
gg_miss_var(airquality, Month, show_pct = TRUE)
gg_miss_var(airquality, Month, show_pct = TRUE) + ylim(0, 100)
}
}
\seealso{
\code{\link[=geom_miss_point]{geom_miss_point()}} \code{\link[=gg_miss_case]{gg_miss_case()}} \link{gg_miss_case_cumsum} \code{\link[=gg_miss_fct]{gg_miss_fct()}} \code{\link[=gg_miss_span]{gg_miss_span()}} \code{\link[=gg_miss_var]{gg_miss_var()}} \code{\link[=gg_miss_var_cumsum]{gg_miss_var_cumsum()}} \code{\link[=gg_miss_which]{gg_miss_which()}}
}
