% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadows.R
\name{bind_shadow}
\alias{bind_shadow}
\title{Bind a shadow dataframe to original data}
\usage{
bind_shadow(data)
}
\arguments{
\item{data}{a dataframe}
}
\value{
dataframe with an extra appended layer of data.
}
\description{
Binding a shadow matrix to a regular dataframe helps visualise and work with
missing data.
}
\examples{

aq_shadow <- bind_shadow(airquality)

# explore missing data visually
library(ggplot2)

# using the bounded shadow

ggplot(data = aq_shadow,
       aes(x = Ozone)) +
       geom_histogram() +
       facet_wrap(~Solar.R_NA,
       ncol = 1)

}
