% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unname_all_chunks.R
\name{unname_all_chunks}
\alias{unname_all_chunks}
\title{Unname chunks in a single file}
\usage{
unname_all_chunks(path)
}
\arguments{
\item{path}{Path to file}
}
\description{
Unname all chunks except the setup chunk, in a single file
}
\details{
When using namer, please check the edits
 before pushing them to your code base. Such automatic
 chunk labelling is best paired with version control.
}
\examples{
temp_file_path <- file.path(tempdir(), "test.Rmd")
file.copy(system.file("examples", "example4.Rmd", package = "namer"),
          temp_file_path,
          overwrite = TRUE)
unname_all_chunks(temp_file_path)
if(interactive()){
file.edit(temp_file_path)
}
}
