% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nadiv-datasets.R
\docType{data}
\name{F2009}
\alias{F2009}
\title{Pedigree, adapted from Fikse (2009)}
\format{An object of class \code{data.frame} with 16 rows and 11 columns.}
\source{
Fikse, F. 2009. Fuzzy classification of phantom parent groups in an
  animal model. Genetics Selection Evolution 41:42.
}
\usage{
F2009
}
\description{
An example pedigree with genetic groups and fuzzy classification of genetic
groups.
}
\details{
A \code{data.frame} with 16 observations on the following 11 variables:
  \describe{
    \item{id }{a factor with levels indicating the unique individuals 
      (including phantom parents) and genetic groups}
    \item{dam }{a factor of observed maternal identities}
    \item{sire }{a factor vector of observed paternal identities}
    \item{damGG }{a factor of maternal identities with genetic groups
      inserted instead of \code{NA}}
    \item{sireGG }{a factor of paternal identities with genetic groups
      inserted instead of \code{NA}}
    \item{phantomDam }{a factor of maternal identities with phantom parents
      inserted instead of \code{NA}}
    \item{phantomSire }{a factor of paternal identities with phantom parents
      inserted instead of \code{NA}}
    \item{group }{a factor of genetic groups to which each phantom parent
      belongs}
    \item{g1 }{a numeric vector with probabilities of group \code{g1}
      membership for each phantom parent}
    \item{g2 }{a numeric vector with probabilities of group \code{g2}
      membership for each phantom parent}
    \item{g3 }{a numeric vector with probabilities of group \code{g3}
      membership for each phantom parent}
  }
}
\examples{
  data(F2009)
  str(F2009)
}
\keyword{datasets}
