% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mzipmed_package.R
\name{lmoutzimedint}
\alias{lmoutzimedint}
\title{Mediation Analysis for Zero-Inflated Count Mediators using MZIP with Exposure-Mediator Interactions (Continuous Outcome)}
\usage{
lmoutzimedint(
  outcome,
  mediator,
  exposure,
  confounder = NULL,
  C = NULL,
  n = 1000,
  X = 1,
  Xstar = 0,
  M = NULL,
  error = "Delta",
  robust = FALSE
)
}
\arguments{
\item{outcome}{is the continuous outcome variable}

\item{mediator}{is the zero-inflated mediator variable, currently only 1 mediator variable is allowed}

\item{exposure}{is the primary exposure being considered, only 1 is allowed}

\item{confounder}{is a vector of confounder variables. If no confounder variables are needed then confounder is set to NULL. If more than 1 confounder is being considered then use the cbind function, e.g. cbind(var1,var2)}

\item{C}{is a vector for theoretical values of each confounder. If left out the default will be set to the mean of each confounder giving marginal effects}

\item{n}{is the number of repetitions for bootstrapping. Default is 1000. Setting n when using delta method errors will have no effect on output.}

\item{X}{is the theoretical value for the exposure variable to be set at. The default is to 1}

\item{Xstar}{is the theoretical value for the exposure variable to be compared to X. The default is 0, so direct, indirect, and proportion mediated values will be for a 1 unit increase in the exposure variable.}

\item{M}{is a fixed value for the mediator, M. If M is not specified, M will be set to its mean value}

\item{error}{='Delta' for delta method standard errors and ='Boot' for bootstrap. Default is delta method}

\item{robust}{indicates if a robust covariance matrix should be used for MZIP in delta method derivations. Default is FALSE.}
}
\value{
The function will return a list of 30 elements.
LM is the results of regressing the mediator+exposure+confounder on the outcome using a linear model. To assess interaction effect individually look in the lm statement at the 4th parameter estimate \cr
MZIP is the results of regressing the exposure and confounders on the mediator using the MZIP model \cr
CDE is the controlled direct effect \cr
NDE is the natural direct effect \cr
NIE is the indirect effect. \cr
PM is the proportion mediated\cr
CDEse is the standard error for the  controlled direct effect \cr
CDEci is the 95\% confidence interval for the controlled direct effect\cr
NDEste is the standard error for the  natural direct effect \cr
NDEci is the 95\% confidence interval for the natural direct effect\cr
NIEse is the standard error for  the indirect effect \cr
NIEci is the 95\% confidence interval for the indirect effect \cr
Intref is the Interactive Reference effect \cr
Intrefse is the standard error for Intref \cr
IntrefCI is the CI for Intref \cr
PIE is the pure indirect effect \cr
PIEse is the standard error of PIE \cr
PIECI is the CI for PIE \cr
Intmed is the interactive mediation effect \cr
Intmedse is the error associated with Intmed \cr
IntmedCI is the CI for Intmed \cr
TE is the total effect \cr
TEse is the error of the total effect \cr
TECI is the CI for the total effect \cr
OvInt is the overall additive interaction effect \cr
OvIntse is the standard error for the additive interaction \cr
OvIntCI is the confidence interval for the interaction effect \cr
PropInt is the proportion attributable to the interaction effect \cr
PE is the proportion eliminated
}
\description{
This function will do the same thing as the lmoutzimed function, but includes an exposure-mediator interaction.
4-way decomposition of total effect (Vanderweele) are included in the output.
}
\examples{
   #Example with exposure-mediator interaction
   #This builds upon function without interaction
    zimmed=lmoutzimedint(outcome=mzipmed_data$lmY,mediator=mzipmed_data$ziM,
                  exposure=mzipmed_data$X,confounder=cbind(mzipmed_data$C1,
                  mzipmed_data$C2),error="Delta",robust=FALSE,X=1,Xstar=0,M=NULL,C=NULL)
}
