% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_test_result.R
\name{ConservationTestResult}
\alias{ConservationTestResult}
\title{Conservation Test Result S7 Class}
\usage{
ConservationTestResult(
  method_name = stop("@method_name is required"),
  test_stat = stop("@test_stat is required"),
  fitting_dist = stop("@fitting_dist is required"),
  params = stop("@params is required"),
  alternative = "two-sided",
  null_sample = stop("@null_sample is required"),
  data_name = character(0),
  p_label = "p_val",
  test_txi = stop("@test_txi is required"),
  null_txis = stop("@null_txis is required"),
  modules = list()
)
}
\arguments{
\item{method_name}{Character string specifying the statistical test method}

\item{test_stat}{Numeric value of the test statistic}

\item{fitting_dist}{Character string specifying the fitted distribution}

\item{params}{Named list of distribution parameters}

\item{alternative}{Character string specifying the alternative hypothesis}

\item{null_sample}{Numeric vector of null distribution values}

\item{data_name}{Character string describing the data}

\item{p_label}{Character string for p-value label}

\item{test_txi}{Numeric vector of observed TXI values}

\item{null_txis}{Matrix of null TXI distributions from permutations}

\item{modules}{Optional list of developmental modules used in the test}
}
\value{
A ConservationTestResult object
}
\description{
S7 class extending TestResult for conservation-specific test results,
including TXI profiles and null distributions.
}
\details{
ConservationTestResult extends TestResult with phylotranscriptomic-specific
information including the observed TXI profile and null TXI distributions
generated by permutation testing.
}
