% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{mc_env_temp}
\alias{mc_env_temp}
\title{Standardised myClim temperature variables}
\usage{
mc_env_temp(
  data,
  period,
  use_utc = TRUE,
  custom_start = NULL,
  custom_end = NULL,
  min_coverage = 1,
  gdd_t_base = 5,
  fdd_t_base = 0
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{period}{output period see \code{\link[=mc_agg]{mc_agg()}}}

\item{use_utc}{if FALSE, then local time is used for day aggregation see \code{\link[=mc_agg]{mc_agg()}} (default TRUE)}

\item{custom_start}{start date for custom period see \code{\link[=mc_agg]{mc_agg()}} (default NULL)}

\item{custom_end}{end date for custom period see \code{\link[=mc_agg]{mc_agg()}} (default NULL)}

\item{min_coverage}{the threshold specifying how many missing values can you accept within aggregation period. see \code{\link[=mc_agg]{mc_agg()}} value from range 0-1 (default 1)}

\item{gdd_t_base}{base temperature for Growing Degree Days \code{\link[=mc_calc_gdd]{mc_calc_gdd()}} (default 5)}

\item{fdd_t_base}{base temperature for Freezing Degree Days \code{\link[=mc_calc_fdd]{mc_calc_fdd()}} (default 0)}
}
\value{
table in long format with standardised myClim variables
}
\description{
The wrapper function returning 7 standardised and ecologically relevant myClim variables
derived from temperature measurements.
}
\details{
This function was designed for time-series of step shorter than one
day and will not work with coarser data. It automatically use all
available sensors in myClim object and returns all possible variables based
on sensor type and measurement height/depth. In contrast with other myClim functions
returning myClim objects, this wrapper function returns long table.
The mc_env_temp function first aggregates time-series to daily time-step
and then aggregates to the final time-step set in \code{period} parameter.
Because freezing and growing degree days are always aggregated with sum function,
these two variables are not first aggregated to the daily time-steps.
Variables are named based on sensor name, height, and function e.g.,
(T.air_15_cm.max95p, T.air_15_cm.drange)

Standardised myClim temperature variables:
\itemize{
\item min5p: Minimum temperature = 5th percentile of daily minimum temperatures
\item mean: Mean temperature = mean of daily mean temperatures
\item max95p: Maximum temperature = 95th percentile of daily maximum temperatures
\item drange: Temperature range = mean of daily temperature range (i.e., difference between daily minima and maxima)
\item GDD5: Growing degree days = sum of growing degree days above defined base temperature (default 5°C) \code{gdd_t_base}
\item FDD0: Freezing degree days = sum of freezing degree days bellow defined base temperature (default 0°C) \code{fdd_t_base}
\item frostdays: Frost days = number of days with frost (daily minimum < 0°C) \code{fdd_t_base}
}
}
\examples{
data <- mc_prep_crop(mc_data_example_clean, lubridate::ymd_h("2020-11-01 00"),
                     lubridate::ymd_h("2021-02-01 00"), end_included = FALSE)
mc_env_temp(data, "month")
}
