% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{mc_read_wide}
\alias{mc_read_wide}
\title{Reading data from wide data.frame}
\usage{
mc_read_wide(
  data_table,
  sensor_id = .model_const_SENSOR_real,
  sensor_name = NULL,
  clean = TRUE,
  silent = FALSE
)
}
\arguments{
\item{data_table}{data.frame with first column of POSIXct time format UTC timezone,
followed by columns with (micro)climatic records. See details.

Columns:
\itemize{
\item datetime column - POSIXct in UTC timezone is required
\item Name of locality[1] - values
\item ...
\item Name of locality[n] - values
}}

\item{sensor_id}{define the sensor type, one of \code{names(mc_data_sensors)} (default \code{real})}

\item{sensor_name}{custom name of sensor; if NULL (default) than \code{sensor_name == sensor_id}}

\item{clean}{if TRUE, then \link{mc_prep_clean} is called automatically while reading (default TRUE)}

\item{silent}{if TRUE, then any information is printed in console (default FALSE)}
}
\value{
myClim object in Raw-format
}
\description{
This is universal function designed to read time-series and values
from wide data.frame to myClim object. Useful for data not coming from
supported microclimatic loggers. E.g. meteorological station data.
}
\details{
The first column of input data.frame must be datetime column in POSIXct time format UTC timezone.
Following columns represents localities. Column names are the localities names.
All values in wide data.frame represents the same sensor type, e.g. air temperature. If you wish to
read multiple sensors use \link{mc_read_long} or use \link{mc_read_wide} multiple times separately
for each sensor type and that merge myClim objects with \link{mc_prep_merge}
By default data are cleaned with function \code{\link[=mc_prep_clean]{mc_prep_clean()}}. See function description. It detects
holes in time-series, duplicated records or records in wrong order.
}
\seealso{
\link{mc_read_long}
}
