% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{mc_env_moist}
\alias{mc_env_moist}
\title{Standardised myClim soil moisture variables}
\usage{
mc_env_moist(
  data,
  period,
  use_utc = TRUE,
  custom_start = NULL,
  custom_end = NULL,
  min_coverage = 1
)
}
\arguments{
\item{data}{cleaned myClim object see \link{myClim-package}}

\item{period}{output period see \code{\link[=mc_agg]{mc_agg()}}}

\item{use_utc}{if FALSE, then local time is used for day aggregation see \code{\link[=mc_agg]{mc_agg()}} (default TRUE)}

\item{custom_start}{start date for custom period see \code{\link[=mc_agg]{mc_agg()}} (default NULL)}

\item{custom_end}{end date for custom period see \code{\link[=mc_agg]{mc_agg()}} (default NULL)}

\item{min_coverage}{the threshold specifying how many missing values can you accept within aggregation period. see \code{\link[=mc_agg]{mc_agg()}} value from range 0-1 (default 1)}
}
\value{
table in long format with standardised myClim variables
}
\description{
The wrapper function returning 4 standardised ecologically relevant myClim variables
derived from soil moisture. The mc_env_moist function needs time-series of
volumetric water content (VWC) measurements as input. Therefore, non-VWC soil
moisture measurements must be first converted to VWC.
For Tomst loggers see \code{\link[=mc_calc_vwc]{mc_calc_vwc()}}
}
\details{
This function was designed for time-series of step shorter than one
day and will not work with coarser data. In contrast with other myClim functions
returning myClim objects this wrapper function return long table.
Variables are named based on sensor name, height, and function e.g.,
(VWC.soil_0_15_cm.5p, VWC.soil_0_15_cm.mean)

Standardised myClim soil moisture variables:
\itemize{
\item VWC.5p: Minimum soil moisture = 5th percentile of VWC values
\item VWC.mean: Mean soil moisture = mean of VWC values
\item VWC.95p: Maximum soil moisture = 95th percentile of VWC values
\item VWC.sd: Standard deviation of VWC measurements
}
}
\examples{
data <- mc_prep_crop(mc_data_example_agg, lubridate::ymd_h("2020-11-01 00"),
                     lubridate::ymd_h("2021-02-01 00"), end_included = FALSE)
data <- mc_calc_vwc(data, localities=c("A2E32", "A6W79"))
mc_env_moist(data, "month")
}
