% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rnc_sgmwcs.R
\name{rnc_solver}
\alias{rnc_solver}
\title{Construct relax-and-cut SGMWCS solver}
\usage{
rnc_solver(
  max_iterations = 1000L,
  beta_iterations = 50L,
  heur_iterations = 10L,
  sep_iterations = 10L,
  verbose = FALSE
)
}
\arguments{
\item{max_iterations}{Maximum number of iterations}

\item{beta_iterations}{Number of nonimproving iterations until beta is halved}

\item{heur_iterations}{Frequency of calling heuristic method (in iterations)}

\item{sep_iterations}{Frequency of separating cuts (in iterations)}

\item{verbose}{Should the solving progress and stats be printed?}
}
\value{
An object of class \code{mwcs_solver}
}
\description{
The solver is based on the same approach as rmwcs solver. Modifications to
the original scheme are introduced to tackle problems arising with introduction
of edge weights and signals. It is recommended to use rmwcs solver to solve MWCS
problems, while due to differences in primal heuristic it may be a good pratice
to run both solvers on the same problem.
}
\seealso{
\link{rmwcs_solver}
}
