/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import ilog.concert.IloAddable;
import ilog.concert.IloException;
import ilog.concert.IloIntVar;
import ilog.concert.IloNumExpr;
import ilog.concert.IloNumVar;
import ilog.concert.IloObjective;
import ilog.concert.IloRange;
import ilog.cplex.IloCplex;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.SolverException;
import ru.itmo.ctlab.virgo.TimeLimit;
import ru.itmo.ctlab.virgo.sgmwcs.Signals;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Blocks;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Unit;
import ru.itmo.ctlab.virgo.sgmwcs.solver.AtomicDouble;
import ru.itmo.ctlab.virgo.sgmwcs.solver.MSTSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.RootedSolver;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Separator;
import ru.itmo.ctlab.virgo.sgmwcs.solver.Utils;

public class RLTSolver
implements RootedSolver {
    private static final double EPS = 1.0E-9;
    private double MIPGap;
    private IloCplex cplex;
    private Map<Node, IloNumVar> y;
    private Map<Edge, IloNumVar> w;
    private Map<Edge, Pair<IloNumVar, IloNumVar>> x;
    private Map<Node, IloNumVar> d;
    private Map<Node, IloNumVar> x0;
    private Map<Integer, IloNumVar> s;
    private Set<Unit> initialSolution;
    private TimeLimit tl;
    private int threads;
    private int logLevel;
    private Graph graph;
    private Signals signals;
    private Node root;
    private boolean isSolvedToOptimality;
    private int maxToAddCuts;
    private int considerCuts;
    private AtomicDouble lb;
    private double externLB;
    private boolean isLBShared;
    private IloNumVar sum;
    private boolean solutionIsTree;
    private IloNumVar prSum;
    private IloNumVar size;

    @Override
    public void setSolIsTree(boolean tree) {
        this.solutionIsTree = tree;
    }

    public RLTSolver(double MIPGap) {
        this.MIPGap = MIPGap;
        this.tl = new TimeLimit(Double.POSITIVE_INFINITY);
        this.threads = 1;
        this.externLB = Double.NEGATIVE_INFINITY;
        this.considerCuts = Integer.MAX_VALUE;
        this.maxToAddCuts = Integer.MAX_VALUE;
    }

    public void setMaxToAddCuts(int num) {
        this.maxToAddCuts = num;
    }

    public void setConsideringCuts(int num) {
        this.considerCuts = num;
    }

    public void setInitialSolution(Set<Unit> solution) {
        this.initialSolution = solution;
    }

    @Override
    public TimeLimit getTimeLimit() {
        return this.tl;
    }

    @Override
    public void setTimeLimit(TimeLimit tl) {
        this.tl = tl;
    }

    public void setThreadsNum(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException();
        }
        this.threads = threads;
    }

    @Override
    public void setRoot(Node root) {
        this.root = root;
    }

    @Override
    public List<Unit> solve(Graph graph, Signals signals) throws SolverException {
        try {
            List<Unit> list;
            boolean applied;
            CplexSolution sol;
            this.isSolvedToOptimality = false;
            if (!this.isLBShared) {
                this.lb = new AtomicDouble(this.externLB);
            }
            this.cplex = new IloCplex();
            this.setCplexLog();
            this.graph = graph;
            this.signals = signals;
            this.initVariables();
            this.addConstraints();
            this.addObjective(signals);
            this.maxSizeConstraints(signals);
            if (this.root == null) {
                this.breakRootSymmetry();
            } else {
                this.tighten();
            }
            if (this.solutionIsTree) {
                this.treeConstraints();
            }
            this.breakTreeSymmetries();
            this.tuning(this.cplex);
            if (graph.edgeSet().size() >= 1) {
                this.cplex.use((IloCplex.Callback)new MSTCallback());
            }
            if (this.initialSolution != null && (sol = this.constructMstSolution(this.initialSolution)) != null && !(applied = sol.apply((vars, vals) -> {
                try {
                    this.cplex.addMIPStart(vars, vals, IloCplex.MIPStartEffort.Repair);
                    return true;
                }
                catch (IloException e) {
                    return false;
                }
            }))) {
                throw new SolverException("MST Heuristic not applied");
            }
            ArrayList<IloRange> constraints = new ArrayList<IloRange>();
            Iterator it = this.cplex.rangeIterator();
            while (it.hasNext()) {
                Object c = it.next();
                constraints.add((IloRange)c);
            }
            boolean solFound = this.cplex.solve();
            if (this.cplex.getCplexStatus() != IloCplex.CplexStatus.AbortTimeLim) {
                this.isSolvedToOptimality = true;
            }
            if (solFound) {
                list = this.getResult();
                return list;
            }
            if (this.initialSolution != null) {
                list = new ArrayList<Unit>(this.initialSolution);
                return list;
            }
            list = Collections.emptyList();
            return list;
        }
        catch (IloException e) {
            throw new SolverException(e.getMessage());
        }
        finally {
            if (this.cplex != null) {
                this.cplex.end();
            }
        }
    }

    private void setCplexLog() {
        if (this.logLevel < 2) {
            this.cplex.setOut(null);
            this.cplex.setWarning(null);
        }
    }

    private void breakTreeSymmetries() throws IloException {
        int n = this.graph.vertexSet().size();
        for (Edge e : this.graph.edgeSet()) {
            Node from = this.graph.getEdgeSource(e);
            Node to = this.graph.getEdgeTarget(e);
            this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(from), this.cplex.prod((double)(n - 1), (IloNumExpr)this.w.get(e))), this.cplex.sum((double)n, (IloNumExpr)this.d.get(to)), "brt" + n);
            this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(to), this.cplex.prod((double)(n - 1), (IloNumExpr)this.w.get(e))), this.cplex.sum((double)n, (IloNumExpr)this.d.get(from)), "brt" + n);
        }
    }

    private void tighten() throws IloException {
        Blocks blocks = new Blocks(this.graph);
        if (!blocks.cutpoints().contains(this.root)) {
            return;
        }
        Separator separator = new Separator(this.y, this.w, this.cplex, this.graph, this.sum, this.lb);
        separator.setMaxToAdd(this.maxToAddCuts);
        separator.setMinToConsider(this.considerCuts);
        for (Set<Node> component : blocks.incidentBlocks(this.root)) {
            this.dfs(this.root, component, true, blocks, separator);
        }
        this.cplex.use((IloCplex.Callback)separator);
    }

    private void dfs(Node root, Set<Node> component, boolean fake, Blocks bs, Separator separator) throws IloException {
        separator.addComponent(this.graph.subgraph(component), root);
        if (!fake) {
            for (Node node : component) {
                this.cplex.addLe(this.cplex.diff((IloNumExpr)this.y.get(node), (IloNumExpr)this.y.get(root)), 0.0, "dfs" + node.getNum());
            }
        }
        for (Edge e : this.graph.edgesOf(root)) {
            if (!component.contains(this.graph.getOppositeVertex(root, e))) continue;
            this.cplex.addEq((IloNumExpr)this.getX(e, root), 0.0, "edge_" + e.getNum() + "root_" + root.getNum());
        }
        for (Node cp : bs.cutpointsOf(component)) {
            if (root == cp) continue;
            for (Set<Node> comp : bs.incidentBlocks(cp)) {
                if (comp == component) continue;
                this.dfs(cp, comp, false, bs, separator);
            }
        }
    }

    @Override
    public boolean isSolvedToOptimality() {
        return this.isSolvedToOptimality;
    }

    private List<Unit> getResult() throws IloException {
        ArrayList<Unit> result = new ArrayList<Unit>();
        for (Node node : this.graph.vertexSet()) {
            if (!(this.cplex.getValue(this.y.get(node)) > 0.5)) continue;
            result.add(node);
        }
        for (Edge edge : this.graph.edgeSet()) {
            if (!(this.cplex.getValue(this.w.get(edge)) > 0.5)) continue;
            result.add(edge);
        }
        return result;
    }

    private void initVariables() throws IloException {
        this.y = new LinkedHashMap<Node, IloNumVar>();
        this.w = new LinkedHashMap<Edge, IloNumVar>();
        this.d = new LinkedHashMap<Node, IloNumVar>();
        this.x = new LinkedHashMap<Edge, Pair<IloNumVar, IloNumVar>>();
        this.x0 = new LinkedHashMap<Node, IloNumVar>();
        this.s = new LinkedHashMap<Integer, IloNumVar>();
        for (Node node : this.graph.vertexSet()) {
            String nodeName = Integer.toString(node.getNum() + 1);
            this.d.put(node, this.cplex.numVar(0.0, Double.MAX_VALUE, "d" + nodeName));
            this.y.put(node, (IloNumVar)this.cplex.boolVar("y" + nodeName));
            this.x0.put(node, (IloNumVar)this.cplex.boolVar("x_0_" + (node.getNum() + 1)));
        }
        HashSet<String> usedEdges = new HashSet<String>();
        for (Edge edge : this.graph.edgeSet()) {
            String edgeName;
            Node from = this.graph.getEdgeSource(edge);
            Node to = this.graph.getEdgeTarget(edge);
            int num = 0;
            do {
                edgeName = from.getNum() + 1 + "_" + (to.getNum() + 1) + "_" + num;
                ++num;
            } while (usedEdges.contains(edgeName));
            usedEdges.add(edgeName);
            this.w.put(edge, (IloNumVar)this.cplex.boolVar("w_" + edgeName));
            IloIntVar in = this.cplex.boolVar("x_" + edgeName + "_in");
            IloIntVar out = this.cplex.boolVar("x_" + edgeName + "_out");
            this.x.put(edge, new Pair<IloIntVar, IloIntVar>(in, out));
        }
    }

    private void tuning(IloCplex cplex) throws IloException {
        if (this.isLBShared) {
            cplex.use((IloCplex.Callback)new MIPCallback(this.logLevel == 0));
        }
        cplex.setParam(IloCplex.Param.Emphasis.MIP, 1);
        cplex.setParam(IloCplex.Param.Threads, this.threads);
        cplex.setParam(IloCplex.Param.Parallel, -1);
        cplex.setParam(IloCplex.Param.MIP.OrderType, 3);
        if (this.MIPGap == 0.0) {
            this.MIPGap = this.getMipGap();
        }
        cplex.setParam(IloCplex.Param.MIP.Tolerances.MIPGap, this.MIPGap);
        if (this.tl.getRemainingTime() <= 0.0) {
            cplex.setParam(IloCplex.Param.TimeLimit, 1.0E-9);
        } else if (this.tl.getRemainingTime() != Double.POSITIVE_INFINITY) {
            cplex.setParam(IloCplex.Param.TimeLimit, this.tl.getRemainingTime());
        }
    }

    private double getMipGap() {
        double absMin = Double.POSITIVE_INFINITY;
        double posSum = 0.0;
        for (int i = 0; i < this.signals.size(); ++i) {
            double w = this.signals.weight(i);
            absMin = Math.min(absMin, Math.abs(w));
        }
        return absMin;
    }

    private void breakRootSymmetry() throws IloException {
        int n = this.graph.vertexSet().size();
        PriorityQueue<Node> nodes = new PriorityQueue<Node>(this.graph.vertexSet());
        int k = n;
        IloNumExpr[] terms = new IloNumExpr[n];
        IloNumExpr[] rs = new IloNumExpr[n];
        while (!nodes.isEmpty()) {
            Node node = nodes.poll();
            terms[k - 1] = this.cplex.prod((double)k, (IloNumExpr)this.x0.get(node));
            rs[k - 1] = this.cplex.prod((double)k, (IloNumExpr)this.y.get(node));
            --k;
        }
        this.prSum = this.cplex.numVar(0.0, (double)n, "prSum");
        this.cplex.addEq((IloNumExpr)this.prSum, this.cplex.sum(terms), "prSum");
        for (int i = 0; i < n; ++i) {
            this.cplex.addGe((IloNumExpr)this.prSum, rs[i], "brs" + k);
        }
    }

    private void addObjective(Signals signals) throws IloException {
        ArrayList<Double> ks = new ArrayList<Double>();
        ArrayList<Object> vs = new ArrayList<Object>();
        double negSum = 0.0;
        double posSum = 0.0;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < signals.size(); ++i) {
            double weight2 = signals.weight(i);
            List<Unit> set = signals.set(i);
            IloNumVar[] vars = (IloNumVar[])set.stream().map(this::getVar).filter(Objects::nonNull).toArray(IloNumVar[]::new);
            IloNumExpr vsum = this.cplex.sum((IloNumExpr[])vars);
            IloIntVar x = this.cplex.boolVar("s" + i);
            for (Unit u : set) {
                IloNumVar r = this.getVar(u);
                this.cplex.addLe((IloNumExpr)r, (IloNumExpr)x);
            }
            if (vars.length == 0 || weight2 == 0.0) continue;
            if (Double.isInfinite(weight2)) {
                this.cplex.addLazyConstraint(this.cplex.range(1.0, vsum, (double)vars.length, "sig_root" + i));
                weight2 = 0.0;
                signals.setWeight(i, 0.0);
            } else if (weight2 > 0.0) {
                min = Math.min(min, weight2);
                posSum += weight2;
            } else {
                negSum += weight2;
            }
            ks.add(weight2);
            if (vars.length == 1) {
                vs.add(vars[0]);
                continue;
            }
            this.s.put(i, (IloNumVar)x);
            vs.add(x);
            if (weight2 >= 0.0) {
                this.cplex.addLe((IloNumExpr)x, vsum, "sig_sum_pos" + i);
                continue;
            }
            this.cplex.addGe(this.cplex.prod((double)vars.length, (IloNumExpr)x), vsum, "sig_sum_neg" + i);
        }
        IloObjective sum = this.cplex.maximize();
        sum.setExpr((IloNumExpr)this.cplex.scalProd(ks.stream().mapToDouble(d -> d).toArray(), vs.toArray(new IloNumVar[0])));
        this.sum = this.cplex.numVar(negSum - 1.0, Double.POSITIVE_INFINITY, "sum");
        this.cplex.addGe(sum.getExpr(), this.lb.get(), "lb");
        this.cplex.addEq((IloNumExpr)this.sum, sum.getExpr(), "seq");
        this.cplex.add((IloAddable)sum);
    }

    private IloNumVar getVar(Unit unit) {
        return unit instanceof Node ? this.y.get(unit) : this.w.get(unit);
    }

    @Override
    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    private void addConstraints() throws IloException {
        this.sumConstraints();
        this.otherConstraints();
        this.distanceConstraints();
    }

    private void distanceConstraints() throws IloException {
        int n = this.graph.vertexSet().size();
        for (Node v : this.graph.vertexSet()) {
            this.cplex.addLe((IloNumExpr)this.d.get(v), this.cplex.diff((double)n, this.cplex.prod((double)n, (IloNumExpr)this.x0.get(v))), "dist" + v.getNum());
        }
        for (Edge e : this.graph.edgeSet()) {
            Node from = this.graph.getEdgeSource(e);
            Node to = this.graph.getEdgeTarget(e);
            this.addEdgeConstraints(e, from, to);
            this.addEdgeConstraints(e, to, from);
        }
    }

    private void addEdgeConstraints(Edge e, Node from, Node to) throws IloException {
        int n = this.graph.vertexSet().size();
        IloNumVar z = this.getX(e, to);
        this.cplex.addGe(this.cplex.sum((double)n, (IloNumExpr)this.d.get(to)), this.cplex.sum((IloNumExpr)this.d.get(from), this.cplex.prod((double)(n + 1), (IloNumExpr)z)), "edge_constraints" + e.getNum() + "_1");
        this.cplex.addLe(this.cplex.sum((IloNumExpr)this.d.get(to), this.cplex.prod((double)(n - 1), (IloNumExpr)z)), this.cplex.sum((IloNumExpr)this.d.get(from), (double)n), "edge_constraints" + e.getNum() + "_2");
    }

    private void maxSizeConstraints(Signals signals) throws IloException {
        for (Node v : this.graph.vertexSet()) {
            for (Node u : this.graph.neighborListOf(v)) {
                Unit[] unitArray = new Unit[]{u};
                if (!(signals.minSum(unitArray) >= 0.0)) continue;
                Edge e = this.graph.getAllEdges(v, u).stream().max(Comparator.comparingDouble(signals::weight)).get();
                Unit[] unitArray2 = new Unit[]{e};
                if (!(signals.minSum(unitArray2) >= 0.0)) continue;
                Unit[] unitArray3 = new Unit[]{e};
                if (!(signals.maxSum(unitArray3) >= 0.0)) continue;
                for (int sig : signals.unitSets((Unit)e)) {
                    this.cplex.addLe((IloNumExpr)this.y.get(v), (IloNumExpr)this.s.getOrDefault(sig, this.w.get(e)));
                }
            }
        }
    }

    private void otherConstraints() throws IloException {
        for (Edge edge : this.graph.edgeSet()) {
            Pair<IloNumVar, IloNumVar> arcs = this.x.get(edge);
            Node from = this.graph.getEdgeSource(edge);
            Node to = this.graph.getEdgeTarget(edge);
            this.cplex.addLe(this.cplex.sum((IloNumExpr)arcs.first, (IloNumExpr)arcs.second), (IloNumExpr)this.w.get(edge), "arcs" + edge.getNum());
            this.cplex.addLe((IloNumExpr)this.w.get(edge), (IloNumExpr)this.y.get(from), "edges_from" + edge.getNum());
            this.cplex.addLe((IloNumExpr)this.w.get(edge), (IloNumExpr)this.y.get(to), "edges_to" + edge.getNum());
        }
    }

    private void sumConstraints() throws IloException {
        this.cplex.addLe(this.cplex.sum((IloNumExpr[])this.graph.vertexSet().stream().map(x -> this.x0.get(x)).toArray(IloNumVar[]::new)), 1.0, "sum31");
        if (this.root != null) {
            this.cplex.addEq((IloNumExpr)this.x0.get(this.root), 1.0, "root");
        }
        for (Node node : this.graph.vertexSet()) {
            Set<Edge> edges = this.graph.edgesOf(node);
            IloNumVar[] xSum = new IloNumVar[edges.size() + 1];
            int i = 0;
            for (Edge edge : edges) {
                xSum[i++] = this.getX(edge, node);
            }
            xSum[xSum.length - 1] = this.x0.get(node);
            this.cplex.addEq(this.cplex.sum((IloNumExpr[])xSum), (IloNumExpr)this.y.get(node), "sum" + node.getNum());
        }
    }

    private void treeConstraints() throws IloException {
        this.cplex.addEq(this.cplex.sum((IloNumExpr[])this.y.values().toArray(new IloNumVar[0])), this.cplex.sum(1.0, this.cplex.sum((IloNumExpr[])this.w.values().toArray(new IloNumVar[0]))), "tree");
    }

    private IloNumVar getX(Edge e, Node to) {
        if (this.graph.getEdgeSource(e) == to) {
            return (IloNumVar)this.x.get((Object)e).first;
        }
        return (IloNumVar)this.x.get((Object)e).second;
    }

    @Override
    public void setLB(double lb) {
        this.externLB = lb;
    }

    public void setSharedLB(AtomicDouble lb) {
        this.isLBShared = true;
        this.lb = lb;
    }

    @Override
    public double getLB() {
        return this.lb.get();
    }

    private Set<Unit> applyPrimalHeuristic(Node treeRoot, Map<Edge, Double> edgeWeights) {
        MSTSolver mst = new MSTSolver(this.graph, edgeWeights, treeRoot);
        mst.solve();
        Graph tree = this.graph.subgraph(this.graph.vertexSet(), mst.getEdges());
        return tree.units();
    }

    private CplexSolution constructMstSolution(Set<Unit> units) {
        if (units.isEmpty()) {
            return null;
        }
        Set<Node> nodes = Utils.nodes(units);
        Node treeRoot = Optional.ofNullable(this.root).orElse((Node)nodes.stream().min(Comparator.naturalOrder()).get());
        return new MSTSolution(this.graph.subgraph((Collection<Unit>)units), treeRoot, units).solution();
    }

    private CplexSolution MSTHeuristic(Map<Edge, Double> weights) {
        Node treeRoot = Optional.ofNullable(this.root).orElse((Node)this.graph.vertexSet().stream().min(Comparator.naturalOrder()).get());
        Set<Unit> units = this.applyPrimalHeuristic(treeRoot, weights);
        return this.constructMstSolution(units);
    }

    private class MIPCallback
    extends IloCplex.IncumbentCallback {
        private boolean silence;

        public MIPCallback(boolean silence) {
            this.silence = silence;
        }

        protected void main() throws IloException {
            double currLB;
            while (!((currLB = RLTSolver.this.lb.get()) >= this.getObjValue())) {
                if (!RLTSolver.this.lb.compareAndSet(currLB, this.getObjValue()) || this.silence) continue;
                System.out.println("Found new solution: " + this.getObjValue());
            }
        }
    }

    private class MSTCallback
    extends IloCplex.HeuristicCallback {
        int i = 0;

        private MSTCallback() {
        }

        protected void main() throws IloException {
            if (RLTSolver.this.lb.get() >= this.getBestObjValue()) {
                this.abort();
                return;
            }
            ++this.i;
            if ((this.i - 1) % 1000 != 0 || this.i > 10000) {
                return;
            }
            HashMap<Edge, Double> weights = new HashMap<Edge, Double>();
            for (Edge e : RLTSolver.this.graph.edgeSet()) {
                Node u = RLTSolver.this.graph.getEdgeSource(e);
                Node v = RLTSolver.this.graph.getEdgeTarget(e);
                double wu = this.getValue((IloNumVar)RLTSolver.this.y.get(u));
                double wv = this.getValue((IloNumVar)RLTSolver.this.y.get(v));
                double we = this.getValue((IloNumVar)RLTSolver.this.w.get(e));
                weights.put(e, 3.0 - wu - we - wv);
            }
            CplexSolution sol = RLTSolver.this.MSTHeuristic(weights);
            assert (sol != null && sol.values.size() == sol.variables.size());
            if (sol.obj() >= this.getIncumbentObjValue()) {
                this.setSolution(sol.variables(), sol.values());
            }
        }
    }

    private class MSTSolution {
        private CplexSolution solution;
        private final Node root;
        private final Graph tree;
        private final Deque<Node> deque;
        private final HashMap<Node, Integer> dist;
        private Set<Unit> mstSol;
        private Set<Node> visitedNodes;
        private Set<Edge> visitedEdges;
        private Set<Node> unvisitedNodes;
        private Set<Edge> unvisitedEdges;

        MSTSolution(Graph tree, Node root, Set<Unit> mstSol) {
            this.solution = new CplexSolution();
            this.tree = tree;
            this.root = root;
            this.mstSol = new HashSet<Unit>(mstSol);
            this.deque = new ArrayDeque<Node>();
            this.dist = new HashMap();
            this.dist.put(root, 0);
            this.visitedNodes = new HashSet<Node>();
            this.visitedEdges = new HashSet<Edge>();
            this.unvisitedNodes = new HashSet<Node>(RLTSolver.this.graph.vertexSet());
            this.unvisitedEdges = new HashSet<Edge>(RLTSolver.this.graph.edgeSet());
            this.traverseSolution();
            this.fillSolution();
        }

        public CplexSolution solution() {
            return this.solution;
        }

        private void traverseSolution() {
            this.deque.add(this.root);
            this.visitedNodes.add(this.root);
            this.mstSol.remove(this.root);
            while (!this.deque.isEmpty()) {
                Node cur = this.deque.pollFirst();
                this.solution.addVariable(RLTSolver.this.x0, cur, cur == this.root ? 1.0 : 0.0);
                this.solution.addVariable(RLTSolver.this.y, cur, 1.0);
                List neighbors = this.tree.neighborListOf(cur).stream().filter(this.mstSol::contains).collect(Collectors.toList());
                this.visitedNodes.addAll(neighbors);
                this.mstSol.removeAll(neighbors);
                for (Node node : neighbors) {
                    Edge e = this.tree.getAllEdges(node, cur).stream().filter(this.mstSol::contains).findFirst().get();
                    this.unvisitedEdges.remove(e);
                    this.visitedEdges.add(e);
                    this.solution.addVariable(RLTSolver.this.w, e, 1.0);
                    this.deque.add(node);
                    this.solution.addVariable(RLTSolver.this.getX(e, node), 1.0);
                    this.solution.addVariable(RLTSolver.this.getX(e, cur), 0.0);
                    this.dist.put(node, this.dist.get(cur) + 1);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void fillSolution() {
            void var2_6;
            this.unvisitedNodes.removeAll(this.visitedNodes);
            for (Edge edge : new ArrayList<Edge>(this.unvisitedEdges)) {
                Node node = RLTSolver.this.graph.getEdgeSource(edge);
                Node v = RLTSolver.this.graph.getEdgeTarget(edge);
                IloNumVar from = RLTSolver.this.getX(edge, node);
                IloNumVar to = RLTSolver.this.getX(edge, v);
                this.solution.addNullVariables(new IloNumVar[]{(IloNumVar)RLTSolver.this.w.get(edge), from, to});
            }
            HashSet<Node> solutionUnits = new HashSet<Node>(this.visitedNodes);
            solutionUnits.addAll(this.visitedEdges);
            for (Map.Entry<Node, Integer> entry : this.dist.entrySet()) {
                this.solution.addVariable(RLTSolver.this.d, entry.getKey(), entry.getValue().intValue());
            }
            for (Node node : this.unvisitedNodes) {
                this.solution.addNullVariables(new IloNumVar[]{(IloNumVar)RLTSolver.this.x0.get(node), (IloNumVar)RLTSolver.this.d.get(node), (IloNumVar)RLTSolver.this.y.get(node)});
            }
            boolean bl = false;
            while (var2_6 < RLTSolver.this.signals.size()) {
                List<Unit> list = RLTSolver.this.signals.set((int)var2_6);
                if (RLTSolver.this.s.containsKey((int)var2_6)) {
                    boolean val = list.stream().anyMatch(solutionUnits::contains);
                    this.solution.addVariable((IloNumVar)RLTSolver.this.s.get((int)var2_6), val ? 1.0 : 0.0);
                }
                ++var2_6;
            }
            this.solution.addVariable(RLTSolver.this.sum, RLTSolver.this.signals.sum(solutionUnits));
        }
    }

    private class CplexSolution {
        private List<IloNumVar> variables = new ArrayList<IloNumVar>();
        private List<Double> values = new ArrayList<Double>();

        private CplexSolution() {
        }

        IloNumVar[] variables() {
            return this.variables.toArray(new IloNumVar[0]);
        }

        double[] values() {
            return this.values.stream().mapToDouble(d -> d).toArray();
        }

        private <U extends Unit> void addVariable(Map<U, IloNumVar> map, U unit, double val) {
            this.addVariable(map.get(unit), val);
        }

        private void addVariable(IloNumVar var, double val) {
            this.variables.add(var);
            this.values.add(val);
        }

        private void addNullVariables(IloNumVar ... vars) {
            for (IloNumVar var : vars) {
                this.addVariable(var, 0.0);
            }
        }

        private boolean apply(BiFunction<IloNumVar[], double[], Boolean> set) {
            double[] vals = new double[this.values.size()];
            for (int i = 0; i < this.values.size(); ++i) {
                vals[i] = this.values.get(i);
            }
            return set.apply(this.variables.toArray(new IloNumVar[0]), vals);
        }

        private double obj() {
            assert (this.values.size() == this.variables.size());
            return this.values.get(this.values.size() - 1);
        }
    }
}

