/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.gmwcs.graph;

import java.util.ArrayList;
import java.util.List;

public abstract class Elem
implements Comparable<Elem> {
    protected int num;
    protected double weight;
    protected List<Elem> absorbed;

    public Elem(int num, double weight2) {
        this.num = num;
        this.weight = weight2;
        this.absorbed = new ArrayList<Elem>();
    }

    public void absorb(Elem elem) {
        for (Elem u : elem.getAbsorbed()) {
            this.absorbed.add(u);
            this.weight += u.weight;
        }
        elem.clear();
        this.absorbed.add(elem);
        this.weight += elem.weight;
    }

    public void clear() {
        for (Elem elem : this.absorbed) {
            this.weight -= elem.getWeight();
        }
        this.absorbed.clear();
    }

    public List<Elem> getAbsorbed() {
        return new ArrayList<Elem>(this.absorbed);
    }

    public int hashCode() {
        return this.num;
    }

    public int getNum() {
        return this.num;
    }

    public double getWeight() {
        return this.weight;
    }

    public void setWeight(double weight2) {
        this.weight = weight2;
    }

    public boolean equals(Object o) {
        return o.getClass() == this.getClass() && this.num == ((Elem)o).num;
    }

    @Override
    public int compareTo(Elem u) {
        if (u.weight != this.weight) {
            return Double.compare(u.weight, this.weight);
        }
        return Integer.compare(u.getNum(), this.num);
    }
}

