% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{marginal_predict}
\alias{marginal_predict}
\title{Marginal Predictions for Multivariate Ordinal Regression Models.}
\usage{
marginal_predict(object, type = "prob", subjectID = NULL, ...)
}
\arguments{
\item{object}{an objecz of class \code{'mvord'}.}

\item{type}{types \code{"prob"}, \code{"class"}, \code{"pred"}, \code{"cum.prob"} are available.}

\item{subjectID}{(optional) vector specifying for which subjectIDs the predictions\cr or fitted values should be computed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Obtains marginal predictions/fitted measures for objects of class \code{'mvord'}.
}
\details{
The following types can be chosen in \code{marginal_predict}:
\tabular{ll}{
  \code{type} \tab description\cr
  \code{"prob"} \tab (default) fitted marginal probabilities for the observed response categories.\cr
  \code{"class"} \tab fitted marginal classes of the observed responses.\cr
  \code{"cum.prob"} \tab fitted marginal cumulative probabilities for the observed response categories.\cr
  \code{"all.prob"} \tab fitted marginal probabilities for all ordered classes of each response.
  }

The current implementation supports only in-sample predictions.
The row names of the output correspond to the subjectIDs.
}
\seealso{
\code{\link{predict.mvord}}, \code{\link{joint_probabilities}}
}
