\name{Distance correlation}
\alias{dcor}
\alias{bcdcor}
\title{
Distance correlation
}

\description{
Distance correlation.
}

\usage{
dcor(y, x)
bcdcor(y, x)
}

\arguments{
\item{y}{
A numerical matrix.
}
\item{x}{
A numerical matrix.
}
}

\details{
The distance correlation or the bias corrected distance correlation of two matrices is calculated. The latter one
is used for the hypothesis test that the distance correlation is zero.).
}

\value{
For the bias corrected distance correlation its value only.
For the distance correlation a list including:
\item{dcov}{
The distance covariance.
}
\item{dvarX}{
The distance variance of x.
}
\item{dvarY}{
The distance variance of Y.
}
\item{dcor}{
The distance correlation.
}
}

\references{
G.J. Szekely, M.L. Rizzo and N. K. Bakirov (2007). Measuring and Testing Independence
by Correlation of Distances. Annals of Statistics, 35(6): 2769--2794.
}

\author{
Michail Tsagris

R implementation and documentation: Michail Tsagris <mtsagris@uoc.gr>.
}

\seealso{
\code{ \link{sq.correl}, \link{rv}
}
}

\examples{
dcor( as.matrix(iris[, 1:2]), as.matrix(iris[, 3:4]) )
bcdcor( as.matrix(iris[, 1:2]), as.matrix(iris[, 3:4]) )
}

