% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_likelihood.R
\name{spectralLikelihood}
\alias{spectralLikelihood}
\title{Spectral log-likelihood function}
\usage{
spectralLikelihood(obs, loc, vario, nCores = 1L, cl = NULL)
}
\arguments{
\item{obs}{List of observations vectors for which \code{sum(x)} exceeds a high threshold.}

\item{loc}{Matrix of coordinates as given by \code{expand.grid()}.}

\item{vario}{Semi-variogram function taking a vector of coordinates as input.}

\item{nCores}{Number of cores used for the computation}

\item{cl}{Cluster instance as created by \code{makeCluster} of the \code{parallel} package.}
}
\value{
Negative spectral log-likelihood function evaluated at the set of observations \code{obs} with semi-variogram \code{vario}.
}
\description{
Compute the negative spectral log-likelihood function for Brown--Resnick model with peaks-over-threshold.
}
\details{
The function compute the negative log-likelihood function based on the spectral representation developed
by Engelke et al. (2015). This simplified expression is obtained by conditioning on the event
`\code{sum(x)} exceeds a high threshold \code{u > 1}'. Margins must have been standardized.
}
\examples{
#Define semi-variogram function
vario <- function(h){
   1 / 2 * norm(h,type = "2")^1.5
}

#Define locations
loc <- expand.grid(1:4, 1:4)

#Simulate data
obs <- simulPareto(1000, loc, vario)

#Evaluate risk functional
sums <- sapply(obs, sum)

#Select exceedances
exceedances <- obs[sums > quantile(sums, 0.9)]

#Evaluate the spectral function
spectralLikelihood(exceedances, loc, vario)
}
\references{
Engelke, S. et al. (2015). Estimation of Huesler-Reiss distributions and Brown-Resnick processes. Journal of the Royal Statistical Society: Series B, 77(1), 239-265
}
