% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotationMatrix.R
\name{rotate3D}
\alias{rotate3D}
\title{Three-Dimensional Rotation Matrix}
\usage{
rotate3D(yaw, pitch, roll)
}
\arguments{
\item{yaw}{z-axis change in degrees; look left (+) or right (-). Consider
this a rotation on the x-y plane.}

\item{pitch}{y-axis change in degrees; look up (-) or down (+). Consider this
a rotation on the x-z plane.}

\item{roll}{x-axis change in degrees; this change appears as if you touch
head to shoulders: right roll (+) and left roll (-).}
}
\value{
A 3 x 3 projection matrix corresponding to the degree changes entered.
}
\description{
Render a 3-Dimensional projection matrix given positive or
  negative degree changes in yaw, pitch, and / or roll.
}
\details{
When plotting with the package scatterplot3d, the default
  perspective is such that the pitch action appears as a roll while the roll
  action appears as a pitch.

  This function is used only in data generation of the package vignette. This
  function is called by rotateScale3D().
}
\examples{
rotate3D(yaw = -10, pitch = 0, roll = 15)

}
\seealso{
Called by: \code{\link{rotateScale3D}}.
}
