% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/faultFilter.R
\name{faultFilter}
\alias{faultFilter}
\title{Process Fault Filtering}
\usage{
faultFilter(trainData, testData, updateFreq, faultsToTriggerAlarm = 5, ...)
}
\arguments{
\item{trainData}{An xts data matrix of initial training observations}

\item{testData}{The data not included in the training data set}

\item{updateFreq}{The number of observations from the test data matrix that
must be returned to update the training data matrix and move it forward.}

\item{faultsToTriggerAlarm}{Specifies how many sequential faults will cause
an alarm to trigger. Defaults to 5.}

\item{...}{Lazy dots for additional internal arguments}
}
\value{
A list of class "fault_ls" with the following:
  \itemize{
    \item{faultObj -- }{An xts flagging matrix with the same number of rows as
      "testData". This flag matrix has the following five columns:
        \itemize{
          \item{SPE -- }{The SPE statistic value for each observation in
            "testData". This statistic is defined as
            \deqn{
              SPE_i = (\textbf{X}_i - \textbf{Y}_i * \textbf{P}^T) *
               (\textbf{X}_i - \textbf{Y}_i * \textbf{P}^T)^T,
            }
            where \eqn{\textbf{X}_i} is the \eqn{i^{th}} observation vector,
            \eqn{\textbf{Y}_i} is the reduced-feature projection of the
            observation \eqn{\textbf{X}_i}, and \eqn{\textbf{P}} is the
            projection matrix such that \eqn{\textbf{X}_i\textbf{P} =
            \textbf{Y}_i}.}
          \item{SPE_Flag -- }{A vector of SPE indicators recording 0 if the
            test statistic is less than or equal to the critical value
            passed through from the threshold object.}
          \item{T2 -- }{The T2 statistic value for each observation in
            "testData". This statistic is defined as
            \deqn{
               T^2_i = \textbf{Y}_i * \textbf{D}^{-1} * \textbf{Y}_i^T,
            }
            where \eqn{\textbf{Y}_i = \textbf{X}_i\textbf{P}} is the reduced-
            feature projection of the observation \eqn{\textbf{X}_i}, and
            \eqn{\textbf{D}} is the diagonal matrix of eigenvalues.}
          \item{T2_Flag -- }{A vector of T2 fault indicators, defined like
            SPE_Flag.}
          \item{Alarm -- }{A column indicating if there have been five flags
            in a row for either the SPE or T2 monitoring statistics or both.
            Alarm states are as follows: 0 = no alarm, 1 = Hotelling's T2
            alarm, 2 = Squared Prediction Error alarm, and 3 = both alarms.}
        }
      }
    \item{nonAlarmedTestObs -- }{An xts matrix of the first updateFreq number
      of rows of the training data which were not alarmed.}
    \item{trainSpecs -- }{The threshold object returned by the internal
      threshold() function. See the threshold() function's help file for more
      details.}
  }
}
\description{
Flag and filter out observations beyond normal operating
  conditions, then return the observations within normal operating
  conditions.
}
\details{
This function is essentially a wrapper function to call and organize
  the output from these other internal functions: faultDetect(), threshold(),
  and pca(). It is applied over a rolling window, with observation width
  equal to updateFreq, of the larger full data matrix via the
  processMonitor() function, wherein the testing and training data sets move
  forward in time across the entire data matrix.

  This internal function is called by processMonitor().
}
\examples{
nrml <- mspProcessData(faults = "NOC")
# Select the data under state 1
data <- nrml[nrml[,1] == 1]

faultFilter(trainData = data[1:672, -1],
            testData = data[673:3360, -1],
            updateFreq = 336)

}
\seealso{
Calls: \code{\link{pca}}, \code{\link{threshold}},
  \code{\link{faultDetect}}. Called by: \code{\link{processMonitor}}.
}
