/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.jhlir.backends.rengine.RCallServicesREngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.MethodHandler;
import org.mutoss.MuTossObject;
import org.mutoss.gui.DebugTextConsole;
import org.mutoss.gui.JavaGDPanel;
import org.mutoss.gui.MuTossGUI;
import org.mutoss.gui.MuTossMainPanel;
import org.mutoss.gui.OutputPanel;
import org.mutoss.gui.dialogs.AlphaDialog;
import org.mutoss.gui.dialogs.ContrastDialog2;
import org.mutoss.gui.dialogs.model.OneEndpointLM;
import org.mutoss.gui.loaddata.RObjectChooser;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.REngine.JRI.JRIEngine;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;

public class MuTossControl
implements ActionListener {
    public static final String LOAD_R_DATA = "load r data";
    public static final String DATA_INFO = "show data info";
    public static final String LOAD_R_P_VALUES = "load r p-values";
    public static final String PVALUE_INFO = "info p-values";
    public static final String ADJ_PVALUE_INFO = "info ajusted p-values";
    public static final String RELECTED_INFO = "info rejected";
    public static final String LOAD_R_MODEL = "load r model";
    public static final String SPECIFY_MODEL = "specify model";
    public static final String MODEL_INFO = "show model info";
    public static final String LOAD_R_HYPOTHESES = "load r hypotheses";
    public static final String DEFINE_CONTRASTS = "define contrasts";
    private static final Log logger = LogFactory.getLog(MuTossControl.class);
    public static final String ER_FWER = "FWER";
    public static final String ER_FWER_WEAK = "FWER_WEAK";
    public static final String ER_GFWER = "GFWER";
    public static final String ER_FDR = "FDR";
    public static final String ER_FDX = "FDX";
    public static final String MODEL_TUKEY = "model tukey";
    public static final String MODEL_DUNNETT = "model dunnett";
    public static final String MODEL_CONTRASTS = "model contrasts";
    public static final String MODEL_ONESAMPLE_T = "model onesample t";
    public static final String MODEL_PAIRED_T = "model paired t";
    public static final String MODEL_TWOSAMPLE_T = "model twosample";
    public static final String MODEL_F = "model f";
    public static final String MODEL_HASLER = "model hasler";
    public static final String MODEL_LM = "model lm";
    public static final String DEFINE_TUKEY = "Tukey";
    public static final String DEFINE_DUNNETT = "Dunnett";
    public static final String MODEL_GILL1 = "gill1";
    public static final String MODEL_GILL2 = "gill2";
    public static final String CI_INFO = "ci info";
    static RCallServicesREngine rcs = null;
    public static DebugTextConsole console = null;
    protected static MuTossControl control = null;
    public static MuTossObject mutossObject = null;

    public static RCallServicesREngine getR() {
        if (rcs == null) {
            Rengine rengine = Rengine.getMainEngine();
            if (rengine == null) {
                if (System.getProperty("eclipse") != null) {
                    console = new DebugTextConsole();
                    rengine = new Rengine(new String[]{"--vanilla"}, true, (RMainLoopCallbacks)console);
                } else {
                    rengine = new Rengine();
                }
            }
            try {
                rcs = new RCallServicesREngine((REngine)new JRIEngine(rengine));
                if (System.getProperty("eclipse") != null) {
                    rcs.eval("require(mutoss)");
                    rcs.eval("require(mutossGUI)");
                    rcs.eval("require(multcomp)");
                    rcs.eval("require(survival)");
                    rcs.eval(".setenv <- if (exists(\"Sys.setenv\")) Sys.setenv else Sys.putenv");
                    rcs.eval(".setenv(\"JAVAGD_CLASS_NAME\"=\"org/mutoss/gui/JavaGD\")");
                    rcs.eval("require(JavaGD)");
                    rcs.eval("pvalues<-c(rep(0.001,5),runif(20))");
                    rcs.eval("data(iris)");
                    rcs.eval("data(InsectSprays)");
                    rcs.eval("amod <- aov(breaks ~ tension, data = warpbreaks)");
                    rcs.eval("X <- matrix(rnorm(1000), ncol=10)");
                    rcs.eval("grouplabels <- rep(c(0,1),each=5)");
                }
            }
            catch (REngineException e) {
                ErrorHandler.getInstance().makeErrDialog("Error creating RCallServicesREngine!", (Object)e);
            }
            OutputPanel.getOutputPanel().getOutputPane().appendParagraph("R Connection established");
        }
        return rcs;
    }

    public MuTossControl() {
        MuTossControl.resetMuTossObject();
    }

    public static void resetMuTossObject() {
        mutossObject = new MuTossObject(".InternalMuTossGUIData");
    }

    public static MuTossControl getInstance() {
        if (control == null) {
            control = new MuTossControl();
        }
        return control;
    }

    public void actionPerformed(ActionEvent e) {
        MuTossMainPanel mp = MuTossGUI.getGUI().getMpanel();
        logger.info((Object)("Got ActionCommand: " + e.getActionCommand()));
        if (e.getActionCommand().equals(LOAD_R_DATA)) {
            logger.info((Object)"Calling RObjectChooser.");
            RObjectChooser roc = new RObjectChooser(MuTossControl.getGUI());
            if (roc.getSelected() != null) {
                MuTossControl.getObj().setData(roc.getSelected(), "RObj: " + roc.getSelected());
            }
        } else if (!e.getActionCommand().equals(DATA_INFO)) {
            if (e.getActionCommand().equals(LOAD_R_MODEL)) {
                logger.info((Object)"Calling RObjectChooser.");
                RObjectChooser roc = new RObjectChooser(MuTossControl.getGUI());
                if (roc.getSelected() != null) {
                    MuTossControl.getObj().setModel(roc.getSelected());
                }
            } else if (!e.getActionCommand().equals(SPECIFY_MODEL)) {
                if (e.getActionCommand().equals(DEFINE_TUKEY)) {
                    MuTossControl.getObj().setStringAsHypotheses(DEFINE_TUKEY);
                } else if (e.getActionCommand().equals(DEFINE_DUNNETT)) {
                    MuTossControl.getObj().setStringAsHypotheses(DEFINE_DUNNETT);
                } else if (!e.getActionCommand().equals(MODEL_INFO)) {
                    if (e.getActionCommand().equals(MODEL_LM)) {
                        new OneEndpointLM(MuTossGUI.getGUI(), MuTossControl.getObj().getData().asRDataFrame());
                    } else if (e.getActionCommand().equals(DEFINE_CONTRASTS)) {
                        new ContrastDialog2((JFrame)MuTossGUI.getGUI(), MuTossControl.getObj().getData().asRDataFrame(), MuTossControl.getObj().getModel());
                    } else if (e.getActionCommand().equals(LOAD_R_P_VALUES)) {
                        logger.info((Object)"Calling RObjectChooser.");
                        RObjectChooser roc = new RObjectChooser(MuTossGUI.getGUI());
                        if (roc.getSelected() != null) {
                            MuTossControl.getObj().setPValues(roc.getSelected(), "RObj: " + roc.getSelected());
                        }
                    } else if (e.getActionCommand().equals(PVALUE_INFO)) {
                        MuTossControl.getR().eval("JavaGD()");
                        MuTossControl.getR().eval("pValuesPlot(" + MuTossControl.getObj().getObjName() + "@pValues)");
                        MuTossControl.getGUI().getTabbedPane().addTab("P-Value Plot", new JavaGDPanel());
                    } else if (e.getActionCommand().equals(ADJ_PVALUE_INFO)) {
                        MuTossControl.getR().eval("JavaGD()");
                        MuTossControl.getR().eval("adjPValuesPlot(" + MuTossControl.getObj().getObjName() + "@adjPValues)");
                        MuTossControl.getGUI().getTabbedPane().addTab("Adjusted P-Value Plot", new JavaGDPanel());
                    } else if (e.getActionCommand().equals(CI_INFO)) {
                        MuTossControl.getR().eval("JavaGD()");
                        MuTossControl.getR().eval("mutoss.plotCI(" + MuTossControl.getObj().getObjName() + "@confIntervals)");
                        MuTossControl.getGUI().getTabbedPane().addTab("Confidence Interval Plot", new JavaGDPanel());
                    } else if (e.getActionCommand().equals(ER_FWER) || e.getActionCommand().equals(ER_GFWER) || e.getActionCommand().equals(ER_FDR)) {
                        new AlphaDialog(MuTossGUI.getGUI(), e.getActionCommand());
                    } else if (e.getActionCommand().equals(MODEL_ONESAMPLE_T)) {
                        MethodHandler.getMethodHandler().apply("mutoss.onesamp.model");
                    } else if (e.getActionCommand().equals(MODEL_PAIRED_T)) {
                        MethodHandler.getMethodHandler().apply("mutoss.paired.model");
                    } else if (e.getActionCommand().equals(MODEL_TWOSAMPLE_T)) {
                        MethodHandler.getMethodHandler().apply("mutoss.twosamp.model");
                    } else if (e.getActionCommand().equals(MODEL_F)) {
                        MethodHandler.getMethodHandler().apply("mutoss.ftest.model");
                    } else if (e.getActionCommand().equals(MODEL_HASLER) || e.getActionCommand().equals(MODEL_GILL1) || e.getActionCommand().equals(MODEL_GILL2)) {
                        JOptionPane.showMessageDialog(MuTossGUI.getGUI(), "Not yet implemented!", "Not yet implemented!", 1);
                    } else if (e.getActionCommand().equals(RELECTED_INFO)) {
                        MuTossControl.getGUI().getTabbedPane().setSelectedIndex(0);
                        MuTossControl.startRecording();
                        MuTossControl.getR().call("mutossGUI:::showRejected", new Object[]{MuTossControl.getObj().getObjName()});
                        MuTossControl.stopRecording("Rejected");
                    } else {
                        MethodHandler.getMethodHandler().apply(e.getActionCommand());
                    }
                }
            }
        }
        mp.enableAllButtons();
    }

    private static MuTossGUI getGUI() {
        return MuTossGUI.getGUI();
    }

    public static MuTossObject getObj() {
        return mutossObject;
    }

    public static void exit(boolean closeGUI) {
        if (closeGUI) {
            MuTossGUI.exit();
        }
        OutputPanel.close();
        mutossObject = null;
        control = null;
    }

    public static void startRecording() {
        MuTossControl.getR().eval("mutossGUI:::startRecording()");
    }

    public static void stopRecording(String header) {
        MuTossControl.getR().eval("mutossGUI:::stopRecording()");
        OutputPanel.getOutputPanel().getOutputPane().appendHeadline(header);
        String[] rOutput = MuTossControl.getR().eval("mutossGUI:::getOutput()").asRChar().getData();
        String outputString = "<p align=\"left\"><pre>";
        for (String ro : rOutput) {
            outputString = outputString + ro + "\n";
        }
        outputString = outputString + "</pre></p>";
        OutputPanel.addOutput(outputString);
        String[] rError = MuTossControl.getR().eval("mutossGUI:::getErrorMsg()").asRChar().getData();
        String errorString = "<p align=\"left\"><font color=#FF0000>";
        for (String ro : rError) {
            errorString = errorString + ro + "\n";
        }
        errorString = errorString + "</font></p>";
        OutputPanel.addOutput(errorString);
    }
}

