/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorDialog;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.ApplicationLog;
import org.af.commons.logging.LoggingSystem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mutoss.MuTossControl;
import org.mutoss.gui.MuTossAssumptionList;
import org.mutoss.gui.MuTossMainPanel;
import org.mutoss.gui.MuTossMenuBar;
import org.mutoss.gui.MuTossTabbedPane;

public class MuTossGUI
extends JFrame
implements WindowListener {
    protected static MuTossGUI gui = null;
    protected MuTossMainPanel mpanel;
    protected MuTossTabbedPane tabbedPane;
    private static final Log logger = LogFactory.getLog(MuTossGUI.class);

    public MuTossTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public MuTossMainPanel getMpanel() {
        return this.mpanel;
    }

    public static void startGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MuTossGUI.getGUI().setVisible(true);
            }
        });
    }

    public static MuTossGUI getGUI() {
        if (gui == null) {
            gui = new MuTossGUI();
        }
        return gui;
    }

    protected MuTossGUI() {
        super("MuToss GUI");
        this.setIconImage(new ImageIcon(this.getClass().getResource("/org/mutoss/images/mutoss.png")).getImage());
        String loggingProperties = "/commons-logging.properties";
        if (System.getProperty("eclipse") != null) {
            loggingProperties = "/commons-logging-verbose.properties";
        }
        if (!LoggingSystem.alreadyInitiated()) {
            LoggingSystem.init((String)loggingProperties, (boolean)true, (boolean)false, (ApplicationLog)new ApplicationLog());
            ErrorHandler.init((String)"rohmeyer@small-projects.de", (String)"http://www.algorithm-forge.com/report/bugreport.php", (boolean)true, (boolean)true, ErrorDialog.class);
        }
        Localizer.getInstance().addResourceBundle("org.mutoss.gui.widgets.ResourceBundle");
        int inset = 50;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(inset, inset, screenSize.width - inset * 2, screenSize.height - inset * 2);
        this.setJMenuBar(new MuTossMenuBar());
        this.setContent();
        this.setVisible(true);
        MuTossControl.getR();
        this.addWindowListener(this);
    }

    public JPanel leftPanel() {
        JPanel panel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        this.mpanel = new MuTossMainPanel();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.mpanel, c);
        ++c.gridy;
        panel.add((Component)new MuTossAssumptionList(), c);
        return panel;
    }

    public void setContent() {
        this.tabbedPane = new MuTossTabbedPane();
        JSplitPane splitPane = new JSplitPane(1, new JScrollPane(this.leftPanel()), this.tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(350);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.ipadx = 5;
        c.ipady = 5;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().add((Component)splitPane, c);
    }

    public static void main(String[] args) {
        MuTossGUI.startGUI();
    }

    @Override
    public void windowActivated(WindowEvent arg0) {
    }

    @Override
    public void windowClosed(WindowEvent arg0) {
        MuTossControl.exit(false);
        MuTossGUI.exit();
    }

    @Override
    public void windowClosing(WindowEvent arg0) {
    }

    @Override
    public void windowDeactivated(WindowEvent arg0) {
    }

    @Override
    public void windowDeiconified(WindowEvent arg0) {
    }

    @Override
    public void windowIconified(WindowEvent arg0) {
    }

    @Override
    public void windowOpened(WindowEvent arg0) {
    }

    public static void exit() {
        if (gui != null) {
            gui.dispose();
        }
        gui = null;
    }
}

