/*
 * Decompiled with CFR 0.152.
 */
package af.statguitoolkit.gui.datawizard;

import af.statguitoolkit.gui.datawizard.DataWizard;
import af.statguitoolkit.gui.datawizard.LoadPanel;
import af.statguitoolkit.io.datasets.FileDescriptorXLS;
import af.statguitoolkit.io.datasets.RFileFormatException;
import af.statguitoolkit.io.datasets.XLSToolkit;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import org.af.commons.Localizer;
import org.af.commons.widgets.lists.MyJComboBox;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardPanelNavResult;

public class LoadXLSPanel
extends LoadPanel
implements ActionListener {
    private MyJComboBox cbSheet;
    DataWizard dataWizard;

    public static String getDescription() {
        return Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_XLS_DESC");
    }

    public LoadXLSPanel(DataWizard dataWizard) {
        this.dataWizard = dataWizard;
        this.makeComponents();
        this.doTheLayout();
    }

    @Override
    protected void makeComponents() {
        super.makeComponents();
        this.cbSheet = new MyJComboBox();
        this.cbSheet.addActionListener((ActionListener)this);
    }

    @Override
    protected void doTheLayout() {
        Localizer loc = Localizer.getInstance();
        String cols = "pref, 5dlu, pref:grow, 5dlu, left:pref, 5dlu, left:pref";
        String rows = "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref:grow";
        FormLayout layout = new FormLayout(cols, rows);
        this.setLayout((LayoutManager)layout);
        CellConstraints cc = new CellConstraints();
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_FILE")), cc.xy(1, 1));
        this.add(this.tfFile, cc.xyw(3, 1, 3));
        this.add(this.bSelect, cc.xy(7, 1));
        JScrollPane sp = new JScrollPane(this.taPreview);
        sp.setBorder(new TitledBorder(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_PREVIEW")));
        this.add(sp, cc.xywh(1, 3, 3, 9));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_XLS_SHEET")), cc.xy(5, 3));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_HEADER")), cc.xy(5, 5));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_MISSING")), cc.xy(5, 7));
        this.add(new JLabel(loc.getString("SGTK_DATAWIZARD_PANEL_CSV_DECPOINT")), cc.xy(5, 9));
        this.add((Component)this.cbSheet, cc.xy(7, 3));
        this.add(this.chbHeader, cc.xy(7, 5));
        this.add(this.tfNA, cc.xy(7, 7));
        this.add(this.tfDec, cc.xy(7, 9));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bSelect) {
            this.selectFile();
        }
        if (e.getSource() == this.cbSheet) {
            this.setPreview(this.getPreview(new File(this.tfFile.getText())));
        }
    }

    private void selectFile() {
        super.selectFile(new String[]{"xls", "xlsx"});
    }

    @Override
    protected void setFile(File file) {
        try {
            this.fillSheetBox(file);
            super.setFile(file);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<String> getPreview(File file) {
        List<String> result;
        Random random = new Random();
        File previewFile = new File(this.getProjectDataSetsPath(), "preview_" + random.nextLong() + ".csv");
        try {
            XLSToolkit.convertXls2Csv(file, this.cbSheet.getSelectedIndex(), previewFile, ";");
            result = this.readLines(previewFile, 20);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        previewFile.delete();
        return result;
    }

    private String getProjectDataSetsPath() {
        return null;
    }

    private void fillSheetBox(File file) throws RFileFormatException, IOException {
        List<String> tables = XLSToolkit.getXLSTables(file);
        this.cbSheet.setModel(tables);
        this.cbSheet.setEnabled(true);
        this.revalidate();
    }

    public WizardPanelNavResult allowFinish(String stepName, Map settings, Wizard wizard) {
        if (this.tfFile.getText().trim().equals("")) {
            JOptionPane.showMessageDialog((Component)((Object)this), Localizer.getInstance().getString("SGTK_DATAWIZARD_PANEL_CSV_PLSSELECTFILE"));
            return WizardPanelNavResult.REMAIN_ON_PAGE;
        }
        this.dataWizard.dataFrameDescriptor = this.getFileDescriptor();
        return WizardPanelNavResult.PROCEED;
    }

    public FileDescriptorXLS getFileDescriptor() {
        if (this.tfFile.getText().trim().equals("")) {
            return null;
        }
        String path = this.tfFile.getText();
        int sheet = this.cbSheet.getSelectedIndex();
        String sheetname = this.cbSheet.getSelectedObject().toString();
        boolean h = this.chbHeader.isSelected();
        String na = this.tfNA.getText();
        Character dec = Character.valueOf(this.tfDec.getText().trim().charAt(0));
        return new FileDescriptorXLS(path, sheet, sheetname, h, na, dec);
    }
}

