% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FWHM.R
\name{FWHM}
\alias{FWHM}
\title{Full width at half maximum}
\usage{
FWHM(x, sub_minimum = TRUE)
}
\arguments{
\item{x}{A time series (numeric)}

\item{sub_minimum}{Logical; should the minimum be subtracted before amplitude normalisation?}
}
\value{
The full width at half maximum of the time series.
}
\description{
Full width at half maximum
}
\examples{
# Number of users connected to the Internet through a server every minute
ts <- datasets::WWWusage

# Calculate FWHM
ts_FWHM <- FWHM(ts)

# Half maximum (for the plots)
hm <- min(ts) + (max(ts) - min(ts)) / 2
hm_plot <- ts
hm_plot[which(hm_plot > hm)] <- hm
hm_plot[which(hm_plot < hm)] <- NA

# Plots
plot(ts, ty = "l", xlab = "Time", ylab = "Number of users")
lines(hm_plot, lwd = 3, col = 2)
}
\references{
Martino, G. et al.
Locomotor patterns in cerebellar ataxia.
J. Neurophysiol. 112, 2810–2821 (2014).
}
