% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data.R
\docType{data}
\name{bs3}
\alias{bs3}
\title{Between-subjects 2×2 design with polytomous response}
\format{
A data frame with 60 observations on the following 4 variables:
\describe{
\item{PId}{a subject identifier with levels \code{"1"} ... \code{"60"}}
\item{X1}{a between-subjects factor with levels \code{"a"}, \code{"b"}}
\item{X2}{a between-subjects factor with levels \code{"c"}, \code{"d"}}
\item{Y}{a polytomous response with categories \code{"yes"}, \code{"no"}, and \code{"maybe"}}
}
}
\description{
This generic synthetic dataset has a polytomous response \code{Y} and two factors
\code{X1} and \code{X2}. The response has categories \code{\{yes,no,maybe\}}.
Factor \code{X1} has levels \code{\{a,b\}}, and factor \code{X2} has levels
\code{\{c,d\}}. It also has a \code{PId} column for participant identifier.
Each participant is on only one row.
}
\examples{
data(bs3, package="multpois")

bs3$PId = factor(bs3$PId)
bs3$Y = factor(bs3$Y, levels=c("yes","no","maybe"))
bs3$X1 = factor(bs3$X1)
bs3$X2 = factor(bs3$X2)
contrasts(bs3$X1) <- "contr.sum"
contrasts(bs3$X2) <- "contr.sum"

m = glm.mp(Y ~ X1*X2, data=bs3)
Anova.mp(m, type=3)
glm.mp.con(m, pairwise ~ X1*X2, adjust="holm")

}
\seealso{
See \code{\link{glm.mp}} and \code{\link{glm.mp.con}} for complete examples.
}
\keyword{datasets}
