%     The multitaper R package
%     Multitaper and spectral analysis package for R
%     Copyright (C) 2013 Karim Rahim 
%
%     Written by Karim Rahim and Wesley Burr.
%
%     This file is part of the multitaper package for R.
%
%     The multitaper package is free software: you can redistribute it and
%     or modify it under the terms of the GNU General Public License as 
%     published by the Free Software Foundation, either version 2 of the 
%     License, or any later version.
%
%     The multitaper package is distributed in the hope that it will be 
%     useful, but WITHOUT ANY WARRANTY; without even the implied warranty 
%     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%     GNU General Public License for more details.
%
%     You should have received a copy of the GNU General Public License
%     along with multitaper.  If not, see <http://www.gnu.org/licenses/>.
%
%     If you wish to report bugs please contact the author. 
%     karim.rahim@gmail.com


\name{plot.mtm.coh}
\alias{plot.mtm.coh}
\title{Compute and plot the multitaper magnitude-squared coherence.}
\description{
   Plots the magnitude-squared coherence for a mtm.coh object computed
   from two equal-parameter mtm objects.
}
\usage{
\method{plot}{mtm.coh}(x,percentGreater=NULL,nehlim=10,nehc=4, cdfQuantilesTicks=NULL,
                       drawPercentLines=TRUE, percentG=c(.1,.2,.5,.8,.9), ...)
}
\arguments{
  \item{x}{An object of the class mtm.coh generated by spec.mtm.coh.}
  \item{percentGreater}{Prints the percent of the coherence function
    greater than the given values in the lower left hand corner.
    The values are expected in a vector representing the percentages.
    For example c(.5, .7) will print the
    percent of the msc that is greater than 50\% and 70\%.}
  \item{nehlim}{A smoothing parameter used in smoothing the
    variance in the final plot. nehlim is the number of points to smooth by
  on each side.}
  \item{nehc}{A smoothing parameter used in smoothing the MSC in the 
    final plot. nehc is the number of points to smooth by on each side.}
  \item{cdfQuantilesTicks}{Percent lines to place the tick marks on the
    right axis (CDF). See the example in mtm.coh for use.}
  \item{drawPercentLines}{Boolean variable indicating if significance lines
    are to be drawn.}
  \item{percentG}{A vector of values for which to print dashed lines
    indicating the percent greater than a particular value. If
    drawpPercentLines is FALSE then this will not be used.}
  \item{...}{Parameters passed to plotting function. Currently
    only tested with xaxs="i".}
}
\references{
Thomson, D.J (1982)
Spectrum estimation and harmonic analysis. \emph{Proceedings of the IEEE}
Volume \bold{70}, number 9, pp. 1055--1096.

Percival, D.B. and Walden, A.T. (1993)
\emph{Spectral analysis for physical applications}
Cambridge University Press. 
}
\examples{
# examples here
}
\keyword{multitaper}
