% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.R
\name{bm_morder}
\alias{bm_morder}
\title{Extension of bigmemory::morder to allow decreasing parameter to be a vector}
\usage{
bm_morder(x, cols, na.last = TRUE, decreasing = FALSE)
}
\arguments{
\item{x}{bigmemmory::big.matrix}

\item{cols}{Columns to sort on}

\item{na.last}{Handling of missing values: TRUE (last), FALSE (first), NA (omit)}

\item{decreasing}{Sort in decreasing order: single value or equal to length of x for tie breaking}
}
\value{
Returns ordering vector
}
\description{
Extension of bigmemory::morder to allow decreasing parameter to be a vector
}
\examples{
\donttest{
bm <- bigmemory::big.matrix (9, 3)
bm[] <- sample(1:3, 27, replace=TRUE)
bm[]
bm_morder (bm, cols=1, decreasing=c(TRUE, FALSE))
bm_morder (bm, cols=1, decreasing=c(FALSE, TRUE))
}
}
\keyword{internal}

