% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-docs.R
\docType{data}
\name{billing2016_suppfig4e}
\alias{billing2016_suppfig4e}
\title{Mass spectrometry intensities by stem cell type and organelle}
\format{
A data frame with 81 rows and the following columns:
\describe{
\item{GeneName}{A factor with three levels naming genes that have interesting
properties.}
\item{Intensity}{A numeric vector of positive intensities of proteins
corresponding to the genes as determined by mass spectrometry.}
\item{StemCellType}{A factor with three levels indicating the type of stem
cell experimented on. "ESC" means embryonic stem cell; "ESC-MSC" means
mesenchymal stem cell derived from an embryonic stem cell; "BM-MSC" means
mesenchymal stem cell derived from bone marrow.}
\item{Organelle}{The region of the cell experimented on. "CH" means
chromatin, "Cyt" means cytosol, "Nuc" means nucleus.}
\item{Replicate}{An integer specifying the experimental replicate.}
\item{Experiment}{The interaction of StemCellType, Organelle and Replicate.}
}
}
\description{
This data was used to create Supplementary Figure 4e of Billing 2016 (see
references).
}
\details{
A data frame of genes corresponding to protein intensities as measured by
mass spectrometry proteomics experiments on embryonic and mesenchymal stem
cells.
}
\examples{
ggplot2::ggplot(billing2016_suppfig4e, ggplot2::aes(Experiment, Intensity)) +
  ggplot2::geom_bar(stat = "identity") +
  ggplot2::geom_vline(xintercept = seq(3.5, 24.5, 3), linetype = "dotted") +
  ggplot2::facet_wrap(~ GeneName) +
  ggplot2::xlab(NULL) +
  ggplot2::theme(axis.text.x = ggplot2::element_text(angle = 45, hjust = 1, size = 4))
}
\references{
Billing AM, Ben Hamidane H, Dib SS, et al. Comprehensive transcriptomic and
proteomic characterization of human mesenchymal stem cells reveals source
specific cellular markers. Scientific Reports. 2016;6:21507.
doi:10.1038/srep21507.

Article text available at:
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4746666}

Supplementary figures available at:
\url{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4746666/bin/srep21507-s1.pdf}
}
\seealso{
\code{\link{billing2016_suppfig4g}}
}
