% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grob_dimensions.R
\name{grob_dimensions}
\alias{grob_dimensions}
\alias{figure_width}
\alias{simplegrobheight}
\alias{simplegrobwidth}
\alias{simple_grob_height}
\alias{simple_grob_width}
\alias{figure_height}
\title{Convenient Access to \code{grob} Dimensions}
\usage{
figure_width(grob, unit_to = "mm")
figure_height(grob, unit_to = "mm")
}
\arguments{
\item{grob}{A \code{\link[grid]{grob}} object for which dimensions are to be
retrieved.}

\item{unit_to}{A single \code{\link{character}} string representing a valid
\pkg{grid}-\code{\link[grid]{unit}}.}
}
\value{
Single \code{\link{numeric}} objects are returned.
}
\description{
Convenience functions extracting dimensions from
\code{\link{grob}} objects.
}
\examples{
# Get dimensions of a grid grob
a_circle <- grid::circleGrob(x = 15, y = 30, r = 15, default.unit = "mm")
figure_height(a_circle)
figure_width(a_circle)

# Use the unit_to arg to convert units
figure_height(a_circle, unit_to = "in")
figure_width(a_circle, unit_to = "cm")

# Get dimensions of a multi-panel figure
figure <- multi_panel_figure(width = 55, height = 55, rows = 2, columns = 2)
figure_height(figure)
figure_width(figure)

# ggsave defaults to measuring dimensions in inches
width <- figure_width(figure, unit_to = "in")
height <- figure_height(figure, unit_to = "in")
tmp_file <- tempfile(fileext = ".png")
ggplot2::ggsave(
  tmp_file, gtable::gtable_show_layout(figure),
  width = width, height = height
)
\donttest{ # Not testing due to use of external software
utils::browseURL(tmp_file)
}
}
\references{
Graumann, J., and Cotton, R.J. (2018). multipanelfigure: Simple
Assembly of Multiple Plots and Images into a Compound Figure. Journal of
Statistical Software 84. doi: 10.18637/jss.v084.c03
}
\seealso{
\code{\link{multi_panel_figure}}, \code{\link{save_multi_panel_figure}}
}
\author{
Johannes Graumann
}
