% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.data.R
\name{create.data}
\alias{create.data}
\title{This function creates model.input for the run.mcmc() function}
\usage{
create.data(detection, occupancy, coords, names, threshold)
}
\arguments{
\item{detection}{a data frame that is one row for every site X season X survey combination
contains columns for the site, season, survey within season, all covariates to be used
in the detection process of the model, and binary indicators of detections for all species
to be modeled}

\item{occupancy}{A data frame that is one row for every site x season combination
contains columns for the site, season, and all covariates to be used in the latent occupancy
process of the model}

\item{coords}{is a data frame that is one row for every site included in the study
contains columns for the site, x, and y
output adjacency based on Euclidean distance threshold the user provides as a function input}

\item{names}{is a list with elements "species", "detection", and "occupancy"
names$species is a vector with the name of every species in the study
names$detection is a vector with the names of the detection covariates
names$occupancy is a vector with the names of the occupancy covariates}

\item{threshold}{is the distance which determines if two locations are neighbors
in the adjacency matrix or not.}
}
\value{
model.input a list with
\itemize{
\item X design matrix for occupancy
\item W design matriw for detection
\item y observed data
\item A adjacency matrix
\item detection.info details for detection
\item occupancy.info details for occupancy
}
}
\description{
This function creates model.input for the run.mcmc() function
}
