% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_hilbig2014_heck2017.R
\docType{data}
\name{heck2017_raw}
\alias{heck2017_raw}
\title{Data: Multiattribute Decisions (Heck, Hilbig & Moshagen, 2017)}
\format{
A data frame with 21 variables:
\describe{
  \item{\code{vp}}{ID code of participant}
  \item{\code{trial}}{Trial index}
  \item{\code{pattern}}{Number of cue pattern}
  \item{\code{ttb}}{Prediction of take-the-best (TTB)}
  \item{\code{eqw}}{Prediction of equal weights (EQW)}
  \item{\code{wadd}}{Prediction of  weighted additive (WADD)}
  \item{\code{logoddsdiff}}{Log-odds difference (WADDprob)}
  \item{\code{ttbsteps}}{Number of TTB steps (TTBprob)}
  \item{\code{itemtype}}{Item type as in paper}
  \item{\code{reversedorder}}{Whether item is reversed}
  \item{\code{choice}}{Choice}
  \item{\code{rt}}{Response time}
  \item{\code{choice.rev}}{Choice (reversed)}
  \item{\code{a1}}{Value of Cue 1 for Option A}
  \item{\code{a2}}{Value of Cue 2 for Option A}
  \item{\code{a3}}{Value of Cue 3 for Option A}
  \item{\code{a4}}{Value of Cue 4 for Option A}
  \item{\code{b1}}{Value of Cue 1 for Option B}
  \item{\code{b2}}{Value of Cue 2 for Option B}
  \item{\code{b3}}{Value of Cue 3 for Option B}
  \item{\code{b4}}{Value of Cue 4 for Option B}
}
}
\usage{
heck2017_raw
}
\description{
Raw data with multiattribute decisions (Heck, Hilbig & Moshagen, 2017).
}
\details{
Each participant made 40 choices for each of 4 item types with four cues
(with validities .9, .8, .7, and .6).
Individual choice freqeuncies are available as \code{\link{heck2017}}
}
\examples{
data(heck2017_raw)
head(heck2017_raw)

\donttest{
# get cue values, validities, and predictions
cueA <- heck2017_raw[, paste0("a", 1:4)]
cueB <- heck2017_raw[, paste0("b", 1:4)]
v <- c(.9, .8, .7, .6)
strat <- strategy_multiattribute(
  cueA, cueB, v,
  c(
    "TTB", "TTBprob", "WADD",
    "WADDprob", "EQW", "GUESS"
  )
)

# get unique item types
types <- strategy_unique(strat)
types$unique

# get table of choice frequencies for analysis
freq <- with(
  heck2017_raw,
  table(vp, types$item_type, choice)
)
freqB <- freq[, 4:1, 1] + # reversed items: Option A
  freq[, 5:8, 2] # non-rev. items: Option B
head(40 - freqB)
data(heck2017)
head(heck2017) # same frequencies (different order)

# strategy classification
pp <- strategy_postprob(
  freqB[1:4, ], rep(40, 4),
  types$strategies
)
round(pp, 3)
}
}
\references{
Heck, D. W., Hilbig, B. E., & Moshagen, M. (2017). From information processing to decisions: Formalizing and comparing probabilistic choice models. Cognitive Psychology, 96, 26-40. \doi{10.1016/j.cogpsych.2017.05.003}
}
\seealso{
\code{\link{heck2017}} for the aggregated choice frequencies per item type.
}
\keyword{datasets}
