% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_multinomial.R
\name{count_multinom}
\alias{count_multinom}
\title{Count How Many Samples Satisfy Linear Inequalities (Multinomial)}
\usage{
count_multinom(k = 0, options, A, b, V, prior = rep(1, sum(options)),
  M = 5000, steps, start, cmin = 0, maxiter = 500, burnin = 5,
  progress = TRUE, cpu = 1)
}
\arguments{
\item{k}{the number of choices for each alternative ordered by item type (e.g.
\code{c(a1,a2,a3,  b1,b2)} for a ternary and a binary item type).
The length of \code{k} must be equal to the sum of \code{options}.
The default \code{k=0} is equivalent to sampling from the prior.}

\item{options}{number of observable categories/probabilities for each item
type/multinomial distribution, e.g., \code{c(3,2)} for a ternary and binary item.}

\item{A}{a matrix defining the convex polytope via \code{A*x <= b}.
The columns of \code{A} do not include the last choice option per item type and
thus the number of columns must be equal to \code{sum(options-1)}
(e.g., the column order of \code{A} for \code{k = c(a1,a2,a2, b1,b2)}
is \code{c(a1,a2, b1)}).}

\item{b}{a vector of the same length as the number of rows of \code{A}.}

\item{V}{a matrix of vertices (one per row) that define the polytope of
admissible parameters as the convex hull over these points
(if provided, \code{A} and \code{b} are ignored).
Similar as for \code{A}, columns of \code{V} omit the last value for each
multinomial condition (e.g., a1,a2,a3,b1,b2 becomes a1,a2,b1).
Note that this method is comparatively slow since it solves linear-programming problems
to test whether a point is inside  a polytope (Fukuda, 2004) or to run the Gibbs sampler.}

\item{prior}{the prior parameters of the Dirichlet-shape parameters.
Must have the same length as \code{k}.}

\item{M}{number of posterior samples drawn from the encompassing model}

\item{steps}{an integer vector that indicates the row numbers at which the matrix \code{A}
is split for a stepwise computation of the Bayes factor (see details).
\code{M} can be a vector with the number of samples drawn
in each step from the (partially) order-constrained models  using Gibbs sampling.
If \code{cmin>0}, samples are drawn for each step until \code{count[i]>=cmin}.}

\item{start}{only relevant if \code{steps} is defined or \code{cmin>0}:
a vector with starting values in the interior of the polytope.
If missing, an approximate maximum-likelihood estimate is used.}

\item{cmin}{if \code{cmin>0}: minimum number of counts per step in the automatic stepwise procedure.
If \code{steps} is not defined, \code{steps=c(1,2,3,4,...)} by default.}

\item{maxiter}{if \code{cmin>0}: maximum number of sampling runs in the automatic stepwise procedure.}

\item{burnin}{number of burnin samples per step that are discarded. Since the
maximum-likelihood estimate is used as a start value (which is updated for each step in
the stepwise procedure in \code{count_multinom}), the \code{burnin}
number can be smaller than in other MCMC applications.}

\item{progress}{whether a progress bar should be shown (if \code{cpu=1}).}

\item{cpu}{either the number of CPUs used for parallel sampling, or a parallel
cluster  (e.g., \code{cl <- parallel::makeCluster(3)}).
All arguments of the function call are passed directly to each core,
and thus the total number of samples is \code{M*number_cpu}.}
}
\value{
a list with the elements

a matrix with the columns
\itemize{
    \item\code{count}: number of samples in polytope / that satisfy order constraints
    \item\code{M}: the  total number of samples in each step
    \item\code{steps}: the \code{"steps"} used to sample from the polytope
        (i.e., the row numbers of \code{A} that were considered stepwise)
}
with the attributes:
\itemize{
   \item\code{proportion}: estimated probability that samples are in polytope
   \item\code{se}: standard error of probability estimate
}
}
\description{
Draws prior/posterior samples for product-multinomial data and counts how many samples are
inside the convex polytope defined by
(1) the inequalities \code{A*x <= b} or
(2) the convex hull over the vertices V.
}
\examples{
### frequencies:
#           (a1,a2,a3, b1,b2,b3,b4)
k <-       c(1,5,9,    5,3,7,8)
options <- c(3,        4)

### linear order constraints
# a1<a2<a3   AND   b2<b3<.50
# (note: a2<a3 <=> a2 < 1-a1-a2 <=> a1+2*a2 < 1)
# matrix A:
#             (a1,a2, b1,b2,b3)
A <- matrix(c(1, -1, 0,  0,  0,
              1,  2, 0,  0,  0,
              0,  0, 0,  1, -1,
              0,  0, 0,  0,  1),
            ncol = sum(options-1), byrow = TRUE)
b <- c(0, 1, 0, .50)

# count prior and posterior samples and get BF
prior <- count_multinom(0, options, A, b, M = 2e4)
posterior <- count_multinom(k, options, A, b, M = 2e4)
count_to_bf(posterior, prior)

bf_multinom(k, options, A, b, M=10000)
bf_multinom(k, options, A, b, cmin = 5000, M = 1000)
}
\references{
Hoijtink, H. (2011). Informative Hypotheses: Theory and Practice for Behavioral and Social Scientists. Boca Raton, FL: Chapman & Hall/CRC.
}
\seealso{
\code{\link{bf_multinom}}, \code{\link{count_binom}}
}
