% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{mcmc_plot.brmcoda}
\alias{mcmc_plot.brmcoda}
\title{MCMC Plots Implemented in \pkg{bayesplot}}
\usage{
\method{mcmc_plot}{brmcoda}(object, ...)
}
\arguments{
\item{object}{A \code{brmcoda} class object.}

\item{...}{Further arguments passed to \code{\link[brms:mcmc_plot.brmsfit]{mcmc_plot.brmsfit}}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot}} object
  that can be further customized using the \pkg{ggplot2} package.
}
\description{
Call MCMC plotting functions
implemented in the \pkg{bayesplot} package.
}
\examples{
\dontrun{
cilr <- complr(data = mcompd, sbp = sbp,
        parts = c("TST", "WAKE", "MVPA", "LPA", "SB"), idvar = "ID")

# model with compositional predictor at between and within-person levels
fit <- brmcoda(complr = cilr,
               formula = Stress ~ bilr1 + bilr2 + bilr3 + bilr4 +
                                 wilr1 + wilr2 + wilr3 + wilr4 + (1 | ID),
               chain = 1, iter = 500)
mcmc_plot(fit)
}
}
\seealso{
\code{\link[brms:mcmc_plot.brmsfit]{mcmc_plot.brmsfit}}
}
