% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareData.R
\name{prepareData}
\alias{prepareData}
\title{Prepare data for estimation}
\usage{
prepareData(Y, W, X, match_on, trimming = NULL, model_options, M_matches,
  J_var_matches)
}
\arguments{
\item{Y}{A response vector (1 x n)}

\item{W}{A treatment vector (1 x n) with numerical values indicating
treatment groups}

\item{X}{A covariate matrix (p x n) with no intercept. When
match_on="existing", then X must be a vector (1 x n) of user-specified
propensity scores.}

\item{match_on}{User specifies "covariates" to match on raw covariates, or
"existing" to match on user-supplied propensity score values, or "polr" or
"multinom" to fit a propensity score model.}

\item{trimming}{an indicator of whether trimming the sample to ensure overlap}

\item{model_options}{A list of the options to pass to propensity model.
Currently under development. Can only pass reference level to multinomial
logistic regression.}

\item{M_matches}{Number of matches per unit for imputing potential outcomes,
as in Abadie and Imbens (2006).}

\item{J_var_matches}{Number of matches when estimating \eqn{\sigma^2(X,W)} as
in Abadie and Imbens (2006).}
}
\value{
A list of information, including the \code{X, W, Y} arguments after
  sorting observeations, and information on \code{unit_ids}, etc.
}
\description{
A series of checks, tests, re-ordering, and other operations to prepare the
data for matching. This function can be run standalone, before running
\code{\link{multiMatch}}.
}
\examples{

 sim_data <- multilevelMatching::simulated_data
 Y <- sim_data$outcome
 W <- sim_data$treatment
 X <- as.matrix(sim_data[ ,-(1:2)])
 names(Y) <- paste0("ID", 1:length(Y))

 trimming <- FALSE
 method <- c("covariates", "polr", "multinom")[2]

 prepared_data <- prepareData(
   Y = Y,
   W = W,
   X = X,
   match_on = "polr",
   trimming = FALSE,
   model_options = list(reference_level = sort(W)[1]),
   M_matches = 3,
   J_var_matches = 2
 )
}
