% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSSearch.R
\name{MSSearch}
\alias{MSSearch}
\title{Local search algorithm for high quality design generation}
\usage{
MSSearch(msopt, alpha, ...)
}
\arguments{
\item{msopt}{A list as returned by the \code{\link[multiDoE]{MSOpt}} function.}

\item{alpha}{A vector of weights, whose elements must sum to one.
\code{length(alpha)} must be equal to the number of criteria considered, that
is it must be equal to the length of the \code{criteria} element of \code{msopt}.}

\item{...}{optional arguments (see \strong{Details}).}
}
\value{
\code{MSSearch} returns a list, whose elements are:
\itemize{
\item{\code{optsol}: A design matrix. The best solution found.}
\item{\code{optscore}: A vector containing the criteria scores for
\code{optsol}.}
\item{\code{feval}: An integer representing the number of score function
evaluations (number of \eqn{f_W} evaluations over all iterations).}
\item{\code{trend}: A vector of length \code{r}. The \eqn{i}-th element is
the value that minimizes \eqn{f_W} for the \eqn{i}-th iteration.}
}
}
\description{
The \code{MSSearch} function can be used to obtain an optimal
multi-stratum experimental design considering one or more optimality criteria,
up to a maximum of six criteria simultaneously. \cr
This function implements the procedure MS-Opt proposed by Sambo, Borrotti,
Mylona e Gilmour (2016) as an extension of the Coordinate-Exchange (CE)
algorithm for constructing approximately optimal designs. This innovative
procedure is able to handle all possible multi-stratum experimental structures
and, instead of minimizing a single objective function as in the original CE
algorithm, it seeks to minimize the following scalarization of the objective
functions for all considered criteria:
\deqn{f_W = \sum_{c \in C}{\alpha_c f_c(d; \eta)=\overline{\alpha} \cdot \overline{f}},}{%
f_W = \sum{c in C}(\alpha_c*f_c(d;\eta)) = \overline{\alpha} \overline{f},}
with
\deqn{\sum_{c \in C} \alpha_c = 1,}{\sum{c in C}(\alpha_c) = 1,}
where \eqn{C} is the set of criteria to be minimized, \eqn{f_c} is the
objective function for the \eqn{c} criterion and \eqn{\overline{\alpha}} is
the vector that controls the relative weights of the objective functions.
}
\details{
\code{MSSearch} by default does not apply any normalization to the
individual objective functions \eqn{f_c} before the calculation of f_w is
performed. However, it is possible to subject the vector of objective functions
\eqn{\overline{f}} to the following transformation:
\deqn{\overline{f}_{norm} = \frac{\overline{f} - CritTR}{CritSC},}{%
\overline{f}_norm = (\overline{f} - CritTR) / CritSC,}
by specifying \eqn{CritTR} and \eqn{CritSC} vectors as additional parameters,
as described below.

Additional arguments can be specified as follows:
\itemize{
\item \code{'Start', sol}: A string and a matrix, used in pair. They provide
a starting solution (or an initial design) to the algorithm. By default the
initial solution is randomly generated following the SampleDesign()
procedure described in Sambo, Borrotti, Mylona and Gilmour (2016).

\item \code{'Restarts', r }: A string and an integer, used in pair. When
\code{r=1}, the default value, the procedure implemented in \code{MSSearch}
results in a local search algorithm that optimizes the objective function
\eqn{f_W} starting from one initial design in the design space. These
parameters allows to restart the algorithm \code{r} times. If no initial design
is passed a different starting solution is generated for each iteration, letting
the probability to find a global minimum be higher. \code{Mssearch} returns
the solution that minimizes \eqn{f_W} across all the \code{r} iterations.

\item \code{'Normalize', c(CritTR, CritSC)}: A string and a vector, used in
pair. By specifying the \code{CritTR} and \code{CritSC} vectors, the user can
establish the normalization factors to be applied to each objective function
before evaluating \eqn{f_W}. \code{CritTR} and \code{CritSC} are vectors of
length equal to the number of criteria, whose default elements are 0 and 1
respectively.
}
}
\examples{
library(multiDoE)

## To check the number of digits to be printed.
backup_options <- options()
options(digits = 10)

## Definition of parameters for experimental setup
facts <- list(1, 2:5)
units <- list(21, 2)
level <- 3
etas <- list(1)
model2 <- "quadratic"

## Single-objective optimization
criteria_S <- c('I')
msopt_S <- MSOpt(facts, units, level, etas, criteria_S, model2)
\donttest{
mssearch_S <- MSSearch(msopt_S, alpha = 1, "Restarts", 100)
}

## Multi-objective optimization
criteria_M <- c('Id', 'Ds', 'As')
msopt_M <- MSOpt(facts, units, level, etas, criteria_M, model2)
\donttest{
mssearch_M <- MSSearch(msopt_M, alpha = c(1/2, 1/4, 1/4), "Restarts", 100)
}

options(backup_options)

## To reduce the computational cost of MSSearch function, you may reduce the number of restarts.

}
\references{
M. Borrotti and F. Sambo and K. Mylona and S. Gilmour. A multi-objective
coordinate-exchange two-phase local search algorithm for multi-stratum
experiments. Statistics & Computing, 2016.
}
