% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common.R
\name{clean_reduntant_rows}
\alias{clean_reduntant_rows}
\title{Removes Redundant Rows in a data frame assuming statefulness}
\usage{
clean_reduntant_rows(df, clean_colname = "value", echo = F,
  clean_na = F)
}
\arguments{
\item{df}{Data.frame in timestamp, value1, value2,...}

\item{clean_colname}{Name of the column to clean as basis}

\item{echo}{Whether to return messages or not}

\item{clean_na}{Whether to clean NA's when they are redundant}
}
\description{
Removes Redundant Rows in a data frame assuming statefulness
}
\examples{
test_interval =
  data.frame(timestamp = as.POSIXct(c(0.5, 1, 1.008, 1.011), origin = "1970-01-01"),
            x     = c("a", "b", "b", "b"),
             y     = c("e", "e", "e", "f"))
clean_reduntant_rows(test_interval, "x")
}
