% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_color.R
\name{color_set_palette}
\alias{color_set_palette}
\title{Generate a color vector}
\usage{
color_set_palette(
  vect = c(),
  vectn = c(),
  cols = c("blue", "cyan", "darkorange"),
  black = "",
  gray9 = ""
)
}
\arguments{
\item{vect}{A vector for groups.}

\item{vectn}{An integer vector with length 0 or with the same length of \code{vect} for order of elements in \code{vect}. default=c()}

\item{cols}{One of
\itemize{
  \item A color names vector
  \item An RGB triplet vector
  \item A HEX vector
}}

\item{black}{A level in \code{vect} that should be assigned to black color. default=""}

\item{gray9}{A level in \code{vect} that should be assigned to gray9 color. default=""}
}
\value{
a named vector
}
\description{
Create a list of colors for a data vector by a list major colors.
}
\examples{
color_set_palette( c('apple', 'orange', 'lime', 'apple'), c(2,1,3,2), 'red', 'blue')

}
