% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/library_search_nist_api.R
\name{LibrarySearchUsingNistApi}
\alias{LibrarySearchUsingNistApi}
\title{Perform the library search using an API from NIST}
\usage{
LibrarySearchUsingNistApi(
  msp_objs,
  mssearch_dir = NULL,
  temp_msp_file_dir = NULL,
  overwrite_spec_list = FALSE,
  comments = NULL
)
}
\arguments{
\item{msp_objs}{A list of nested lists. Each nested list is a mass spectrum. Each nested
list must contain at least three elements: (1) \code{name} (a string) -
compound name (or short description); (2) \code{mz} (a numeric/integer
vector) - m/z values of mass spectral peaks; (3) \code{intst} (a
numeric/integer vector) - intensities of mass spectral peaks. The number of
mass spectra should be 100 or less.}

\item{mssearch_dir}{A string. Full path to the \emph{MSSEARCH/} directory (e.g.
\emph{C:/NIST20/MSSEARCH/}). This directory must contain the
\emph{nistms$.exe} file. If \code{NULL}, an attempt is made to find the
path automatically using the \emph{win.ini} file.}

\item{temp_msp_file_dir}{A string. Path to a directory where a temporary msp-file is created. If
\code{NULL}, the temporary file is created in the \emph{MSSEARCH/}
directory}

\item{overwrite_spec_list}{A logical value. If \code{TRUE}, all spectra in the 'Spec List' of the MS
Search (NIST) software are overwritten.}

\item{comments}{Any R object. Some additional information (e.g., library search options,
the list of used libraries, etc.). It is saved as the 'comments' attribute
of the returned list.}
}
\value{
Return a list of data frames. Each data frame is a hitlist. The name of
  unknown compound and compound in Library Factor (InLib) are saved as the
  \code{unknown_name} and \code{inlib} attributes of the respective data
  frame. Data frames contain the following elements:
  \describe{
    \item{\code{name}}{A character vector. Compound name.}
    \item{\code{mf}}{An integer vector. Match factor.}
    \item{\code{rmf}}{An integer vector. Reverse match factor.}
    \item{\code{prob}}{A numeric vector. Probability.}
    \item{\code{lib}}{A character vector. Library.}
    \item{\code{cas}}{A character vector. CAS number.}
    \item{\code{formula}}{A character vector. Chemical formula.}
    \item{\code{mw}}{An integer vector. Molecular weight.}
    \item{\code{id}}{An integer vector. ID in the database.}
    \item{\code{ri}}{A numeric vector. Retention index.}
  }
}
\description{
Perform the library search using an API for the MS Search software (NIST).
  The search is performed by calling the \emph{nistms$.exe} file. The API is
  described in the NIST Mass Spectral Search Program manual. Library search
  options are set within the MS Search (NIST) software. To perform automatic
  library search the following settings should be set: (1) the 'Automatic
  Search On' box should be checked; (2) the 'Number of Hits to Print' field
  should contain reasonable value of candidates (e.g., 100).
}
\details{
The function was tested using the MS Search (NIST) software (version 2.4)
  and the NIST20 mass spectral database. Only two algorithms have been tested
  yet: 'Identity EI Normal' and 'Similarity EI Simple'.

  A few temporary files are created in the \emph{MSSEARCH/} directory
  according to the description provided in the NIST Mass Spectral Search
  Program manual.

  Library search options are set within the MS Search (NIST) software. To do
  it, perform the following steps.
  \itemize{
    \item Open the MS Search (NIST) software.
    \item Press the 'Library Search Options' button.
    \item Select the required algorithm on the 'Search' tab (e.g., 'Identity,
    EI Normal').
    \item Select the required set of libraries on the 'Libraries' tab.
    \item Ensure that the 'Automatic Search On' box is checked ('Automation'
    tab).
    \item Set the 'Number of Hits to Print' to reasonable value (e.g., 100)
    on the 'Automation' tab.
    \item Change other settings according to the goal (e.g., 'Presearch',
    'Limits', 'Constraints', etc.).
  }
}
\examples{
\dontrun{

# To run this example, ensure that MS Search (NIST) software is installed.

# Reading the 'alkanes.msp' file
msp_file <- system.file("extdata", "alkanes.msp", package = "mssearchr")
msp_objs <- ReadMsp(msp_file)

# Searching using the MS Search (NIST) API
hitlists <- LibrarySearchUsingNistApi(msp_objs)
print(hitlists[[1]][1:5, ])

#>           name  mf rmf  prob              lib cas formula  mw id ri
#> 1     UNDECANE 951 960 55.70 massbank_alkanes   0  C11H24 156 11  0
#> 2     UNDECANE 928 928 20.34 massbank_alkanes   0  C11H24 156 72  0
#> 3     DODECANE 906 929  8.04 massbank_alkanes   0  C12H26 170 74  0
#> 4    TRIDECANE 892 907  5.03 massbank_alkanes   0  C13H28 184 41  0
#> 5     DODECANE 886 900  3.95 massbank_alkanes   0  C12H26 170 42  0
}

}
