% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.r
\docType{methods}
\name{cvmsma}
\alias{cvmsma}
\title{Cross-Validation}
\usage{
cvmsma(
  X,
  Y = NULL,
  Z = NULL,
  comp = 1,
  lambdaX,
  lambdaY = NULL,
  lambdaXsup = NULL,
  lambdaYsup = NULL,
  eta = 1,
  type = "lasso",
  inX = NULL,
  inY = NULL,
  inXsup = NULL,
  inYsup = NULL,
  muX = 0,
  muY = 0,
  nfold = 5,
  seed = 1,
  intseed = 1
)
}
\arguments{
\item{X}{a (list of) matrix, explanatory variable(s).}

\item{Y}{a (list of) matrix, objective variable(s).}

\item{Z}{a (list of) matrix, response variable(s).}

\item{comp}{numeric scalar for the maximum number of componets to be considered.}

\item{lambdaX}{numeric vector of regularized parameters for X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaY}{numeric vector of regularized parameters for Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaXsup}{numeric vector of regularized parameters for the super weight of X with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{lambdaYsup}{numeric vector of regularized parameters for the super weight of Y with length equal to the number of blocks. If omitted, no regularization is conducted.}

\item{eta}{numeric scalar the parameter indexing the penalty family.}

\item{type}{a character.}

\item{inX}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inY}{a (list of) numeric vector to specify the variables of X which are always in the model.}

\item{inXsup}{a (list of) numeric vector to specify the blocks of X which are always in the model.}

\item{inYsup}{a (list of) numeric vector to specify the blocks of Y which are always in the model.}

\item{muX}{a numeric scalar for the weight of X for the supervised.}

\item{muY}{a numeric scalar for the weight of Y for the supervised.}

\item{nfold}{number of folds - default is 5.}

\item{seed}{number of seed for the random number.}

\item{intseed}{seed number for the random number in the parameter estimation algorithm.}
}
\value{
\item{err}{The mean cross-validated errors which has three elements consisting of the mean of errors for X and Y, the errors for X and for Y.}
}
\description{
cross-validated method to evaluate the fit of "msma".
}
\details{
k-fold cross-validation for \code{msma}
}
\examples{
##### data #####
tmpdata = simdata(n = 50, rho = 0.8, Yps = c(10, 12, 15), Xps = 20, seed=1)
X = tmpdata$X; Y = tmpdata$Y 

##### One Component CV #####
cv1 = cvmsma(X, Y, comp = 1, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv1

##### Two Component CV #####
cv2 = cvmsma(X, Y, comp = 2, lambdaX=2, lambdaY=1:3, nfold=5, seed=1)
cv2

}
