% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oncotree_to_nci.R
\name{nci_to_oncotree}
\alias{nci_to_oncotree}
\title{Map NCI to OncoTree codes}
\usage{
nci_to_oncotree(
  nci_code = NULL,
  oncotree_version = "oncotree_latest_stable",
  expand = FALSE
)
}
\arguments{
\item{nci_code}{NCI codes.}

\item{oncotree_version}{OncoTree database release version.}

\item{expand}{Whether to expand one-to-many mappings. If \code{TRUE}, one-to-many mappings are expanded into several rows in the output.}
}
\value{
A \link[tibble:tibble-package]{tibble} of two variables: \code{nci_code} and \code{oncotree_code}.
}
\description{
This function maps National Cancer Institute Thesaurus (NCIt) codes to OncoTree codes.
}
\examples{
# Leave `nci_code` empty to return mappings for all NCI codes
nci_to_oncotree()

# Map a few selected OncoTree codes
nci_to_oncotree(nci_code = c('C8969', 'C4862', 'C9168', 'C7967'))

# Use `expand` to make sure the column `oncotree_code` is a character vector
# and not a list-column. One-to-many mappings will result in more than row
# with `oncotree_code` values repeated.
nci_to_oncotree(nci_code = c('C8969', 'C4862', 'C9168', 'C7967'), expand =
TRUE)

}
