% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spelling.R
\name{spell_check_msgs}
\alias{spell_check_msgs}
\title{Spell check diagnostic messages}
\usage{
spell_check_msgs(dict = "en_US", pkg = ".")
}
\arguments{
\item{dict}{A \code{\link[hunspell]{dictionary}} object.}

\item{pkg}{The directory of an R package to extract diagnostic messages from. Path is passed to \code{\link[devtools]{as.package}}.}
}
\value{
A data frame containing each message with a potentially misspelled word, the misspelled word, and the source code file in which the message is located, and (for each word) a list of suggested corrections. If no words are misspelled, a data frame with zero rows.
}
\description{
Extracts diagnostic messages from a package and checks them for spelling errors.
}
\details{
Extracts diagnostic messages from a package and processes them using \code{\link[hunspell]{hunspell}} to check for possible spelling mistakes.
}
\examples{
\dontrun{
  # Not run since it takes too long
  pkg <- extract_example_pkg()
  spell_check_msgs(pkg)
}
}
\seealso{
\code{\link{get_messages}}, \code{\link{get_message_distances}}
}
\author{
Thomas J. Leeper
}
