\name{features.msgl}
\alias{features.msgl}
\title{Nonzero features}
\usage{
  \method{features}{msgl} (object, ...)
}
\arguments{
  \item{object}{a msgl object}

  \item{...}{ignored}
}
\value{
  a list of of length \code{nmod(x)} containing the nonzero
  features (that is nonzero colums of the beta matrices)
}
\description{
  Extracts the nonzero features for each model.
}
\examples{
data(SimData)
x <- sim.data$x
classes <- sim.data$classes
lambda <- msgl.lambda.seq(x, classes, alpha = .5, d = 50, lambda.min = 0.05)
fit <- msgl(x, classes, alpha = .5, lambda = lambda)

# the nonzero features of model 1, 10 and 25
features(fit)[c(1,10,25)]

# count the number of nonzero features in each model
sapply(features(fit), length)
}
\author{
  Martin Vincent
}

