\name{iterGlmCV}
\alias{iterGlmCV}
\title{ cross-validation for iterative glm }
\description{
 Get the cross-validation R squared for iterative glm.
}
\usage{
iterGlmCV(data, fold = 5, seed = 281142, thrd = 0.01, max_iter = 10)
}
\arguments{
  \item{data}{ the data frame generated by \code{expData.R} }
  \item{fold}{ number of folds of CV }
  \item{seed}{ seed to generate training indexes }
  \item{thrd}{ threshold for R squared increase in iterative glm }
  \item{max_iter}{ maximum times of iterations in iterative glm }
}
\value{
 the CV R squared, a numeric value
}
\examples{
 # read and expand the data
 data(g1_part) # for real data, please use read.csv, like g1 <- read.csv("g1.csv")
 data <- expData(g1_part, 2, 3) # In real datasets, surrounding sequences should be set longer.
 
 # get the CV R squared for Poisson linear model
 R_sq <- iterGlmCV(data)
}
\keyword{ models }
\keyword{ regression }
