% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ms_chart.R
\name{ms_linechart}
\alias{ms_linechart}
\title{linechart object}
\usage{
ms_linechart(data, x, y, group = NULL)
}
\arguments{
\item{data}{a data.frame}

\item{x}{x colname}

\item{y}{y colname}

\item{group}{grouping colname used to split data into series. Optional.}
}
\description{
Creation of a linechart object that can be
inserted in a 'Microsoft' document.
}
\examples{
library(officer)
mytheme <- mschart_theme(
  axis_title_x = fp_text(color = "red", font.size = 24, bold = TRUE),
  axis_title_y = fp_text(color = "green", font.size = 12, italic = TRUE),
  grid_major_line_y = fp_border(width = 1, color = "orange"),
  axis_ticks_y = fp_border(width = 1, color = "orange") )

# example chart_01 -------
chart_01 <- ms_linechart(data = iris, x = "Sepal.Length",
                      y = "Sepal.Width", group = "Species")
chart_01 <- chart_ax_y(chart_01, num_fmt = "0.00", rotation = -90)
chart_01 <- set_theme(chart_01, mytheme)


# example chart_02 -------
chart_02 <- ms_linechart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
chart_02 <- chart_ax_y(chart_02, cross_between = "between", num_fmt = "General")
chart_02 <- chart_ax_x(chart_02, cross_between = "midCat", num_fmt = "m/d/yy")
chart_02 <- set_theme(chart_02, mytheme)


# example chart_03 -------
chart_03 <- ms_linechart(data = browser_ts, x = "date",
                      y = "freq", group = "browser")
chart_03 <- chart_ax_x(chart_03, cross_between = "midCat", num_fmt = "m/d/yy")
chart_03 <- chart_settings(chart_03, grouping = "percentStacked")

}
\seealso{
Other 'Office' chart objects: 
\code{\link{ms_areachart}()},
\code{\link{ms_barchart}()},
\code{\link{ms_scatterchart}()}
}
\concept{'Office' chart objects}
