% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saedb.R
\name{saedb}
\alias{saedb}
\title{EBLUPs under Univariate Fay Herriot Model with Difference Benchmarking}
\usage{
saedb(
  formula,
  vardir,
  weight,
  samevar = FALSE,
  MAXITER = 100,
  PRECISION = 1e-04,
  data
)
}
\arguments{
\item{formula}{List of formula that describe the fitted model}

\item{vardir}{Sampling variances of direct estimations,if it is included in data frame so it is the vector with the name of sampling variances.if it is not, it is a data frame of sampling variance in order : \code{var1, cov12,.,cov1r,var2,cov23,.,cov2r,.,cov(r-1)(r),var(r)}}

\item{weight}{Known proportion of units in small areas, where \eqn{\sum_{d=1}^{D}}{sum from d=1 to D of} \eqn{W_{rd}}{Wrd} = 1 . \code{d = 1...D}  is the number of small areas, and \code{r = 1...R}  is the number of response variables}

\item{samevar}{Whether the variances of the data are same or not. Logical input with default \code{FALSE}}

\item{MAXITER}{Maximum number of iteration in Fisher-scoring algorithm with default \code{100}}

\item{PRECISION}{Limit of Fisher-scoring convergence tolerance with default \code{1e-4}}

\item{data}{The data frame}
}
\value{
This function returns a list of the following objects:
   \item{SAE_Eblup}{A dataframe with the values of the EBLUPs estimators}
   \item{MSE_Eblup}{A dataframe with the values of estimated mean square errors of EBLUPs estimators}
   \item{randomEffect}{A dataframe with the values of the random effect estimators}
   \item{Rmatrix}{A block diagonal matrix composed of sampling errors}
   \item{fit}{A list containing the following objects:}
     \itemize{
       \item method : The fitting method (this function is using "REML")
       \item convergence : The convergence result of Fisher-scoring algorithm (Logical Value)
       \item iterations : The number of Fisher-Scoring algorithm iterations
       \item estcoef : A dataframe with the estimated model coefficient, standard error,t statistics, p-values of the significance of each coefficient
       \item refvar : A dataframe with estimated random effect variances
       \item informationFisher : A matrix of information fisher from Fisher-scoring algorithm
     }

   \item{difference_benchmarking}{a list containing the following objects:}
     \itemize{
       \item Estimation : A dataframe with the value of Benchmarked EBLUPs estimators
       \item Aggregation : The aggregation of benchmarked EBLUPs estimators, EBLUPs estimators and direct estimations
       \item MSE_DB : A dataframe with the values of estimated mean square errors of benchmarked EBLUPs estimators
       \item g.4a : First component of g4 in difference benchmarking MSE estimation formula
       \item g.4b : Second component of g4 in difference benchmarking MSE estimation formula
     }
}
\description{
This function produces EBLUPs, MSE, and aggregation of Univariate SAE with Difference Benchmarking
}
\examples{
##load dataset
data(datamsaeDB)

#Compute Fitted model for Y1, Y2, and Y3
#Y1 ~ X1 + X2
#Y2 ~ X2
#Y3 ~ X1

##Using parameter 'data'
formula = list(f1 = Y1~X1+X2,
               f2 = Y2~X2,
               f3 = Y3~X1)
vardir = c("v1","v12","v13","v2","v23","v3")
#Note : in real data for univariate SAE, if you does not have the values of covariances,
#       set covariancse as zero in the dataframe

weight = c("w1","w2","w3")
saeDB <- saedb(formula, vardir, weight, data=datamsaeDB)

##Do not use parameter 'data'
formula = list(f1 = datamsaeDB$Y1~datamsaeDB$X1+datamsaeDB$X2,
               f2 = datamsaeDB$Y2~datamsaeDB$X2,
               f3 = datamsaeDB$Y3~datamsaeDB$X1)
vardir = datamsaeDB[,c("v1","v12","v13","v2","v23","v3")]
#Note : in real data for univariate SAE, if you does not have the values of covariances,
#       set covariancse as zero in the dataframe
weight = datamsaeDB[,c("w1","w2","w3")]
saeDB_d <- saedb(formula, vardir, weight = weight)

saeDB$SAE_Eblup        #to see EBLUP Estimators
saeDB$MSE_Eblup        #to see estimated MSE of EBLUP estimators
saeDB$difference_benchmarking$Estimation   #to see Benchmarked EBLUP Estimators
saeDB$difference_benchmarking$MSE_DB       #to see estimated MSE of Benchmarked EBLUP Estimators
saeDB$difference_benchmarking$Aggregation  #to see the aggregation of, benchmarking

}
