% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmxml.R
\name{nmxml}
\alias{nmxml}
\alias{NMXML}
\title{Get THETA, OMEGA and SIGMA from a completed NONMEM run}
\usage{
nmxml(run = numeric(0), project = character(0), file = character(0),
  theta = TRUE, omega = FALSE, sigma = FALSE, olabels = NULL,
  slabels = NULL, oprefix = "", sprefix = "", tname = "THETA",
  oname = "...", sname = "...", ...)
}
\arguments{
\item{run}{run number}

\item{project}{project directory}

\item{file}{the complete path to the \code{run.xml} file}

\item{theta}{logical; if TRUE, the \code{$THETA} vector is returned}

\item{omega}{logical; if TRUE, the \code{$OMEGA} matrix is returned}

\item{sigma}{logical; if TRUE, the \code{$SIGMA} matrix is returned}

\item{olabels}{labels for \code{$OMEGA}}

\item{slabels}{labels for \code{$SIGMA}}

\item{oprefix}{prefix for \code{$OMEGA} labels}

\item{sprefix}{prefix for \code{$SIGMA} labels}

\item{tname}{name for \code{$THETA}}

\item{oname}{name for \code{$OMEGA}}

\item{sname}{name for \code{$SIGMA}}

\item{...}{passed along}
}
\value{
a list with theta, omega and sigma elements, depending on what was requested
}
\description{
Get THETA, OMEGA and SIGMA from a completed NONMEM run
}
\details{
If \code{run} and \code{project} are supplied, the .xml file is assumed to be located in \code{run.xml}, in directory \code{run} off the \code{project} directory.  If \code{file} is supplied, \code{run} and \code{project} arguments are ignored.
}
