% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suf_stat.R
\name{smr_array}
\alias{smr_array}
\title{Summarized representation of theta arrays}
\usage{
smr_array(theta, family)
}
\arguments{
\item{theta}{A 3-dimensional array describing potentials. Slices represent
interacting positions, rows represent pixel values and columns represent
neighbor values. As an example: \code{theta[1,3,2]} has the potential pairs of
values 0,2 in the second relative position of \code{mrfi}.}

\item{family}{The family of parameter restrictions to potentials. Families
are:
\code{'onepar'}, \code{'oneeach'}, \code{'absdif'}, \code{'dif'} or \code{'free'}.
See \code{\link[=mrf2d-family]{mrf2d-familiy}}.}
}
\value{
A numeric vector with the free parameters of \code{theta}.
}
\description{
Creates a vector with only the free parameters from an array.
}
\details{
The order the parameters appear in the vector matches
the order in \code{\link[=smr_stat]{smr_stat()}}.
}
\examples{
smr_array(theta_potts, "onepar")
smr_array(theta_potts, "oneeach")

}
\author{
Victor Freguglia
}
