% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_wkt.R
\name{mr_as_wkt}
\alias{mr_as_wkt}
\title{Convert data to WKT}
\usage{
mr_as_wkt(x, fmt = 16, ...)
}
\arguments{
\item{x}{Output from \code{\link{mr_geojson}}, \code{\link{mr_shp}},
or a \code{SpatialPolygonsDataFrame}}

\item{fmt}{(integer) The number of digits to display after the decimal point when
formatting coordinates. Ignored when shp files or \code{SpatialPolygonsDataFrame}
passed in}

\item{...}{Further args passed on to \code{\link[jsonlite]{fromJSON}} only in the
event of json passed as a character string. Ignored when shp files or
\code{SpatialPolygonsDataFrame} passed in}
}
\value{
a character string of WKT data
}
\description{
Convert data to WKT
}
\details{
WKT, or Well Known Text, is a way to encode spatial data. It's somewhat
similar to GeoJSON, but instead of being in JSON format, it's a character string
(though can also be encoded in binary format). WKT is often used in SQL databases,
and many species occurrence APIs allow only WKT. You could do the conversion to
WKT yourself, but we provide \code{as_wkt} as a convenience
}
\examples{
\dontrun{
res <- mr_geojson(key = "MarineRegions:eez_33176")
mr_as_wkt(res, fmt = 5)

nms <- mr_names()
res <- mr_geojson(key = grep("MarineRegions", nms$name, value = TRUE)[10])
mr_as_wkt(res, fmt = 5)

# shp files
## path to wkt
mr_as_wkt(mr_shp(key = "MarineRegions:eez_33176", read = FALSE))

## spatial object to wkt
mr_as_wkt(mr_shp(key = "MarineRegions:eez_33176", read = TRUE))
}
}

