% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPWmap.R
\name{HPWmap}
\alias{HPWmap}
\title{Computation of pointwise and highest pointwise probabilities.}
\usage{
HPWmap(smoothVec, mm, nn, prob = 0.95)
}
\arguments{
\item{smoothVec}{Differences of smooths at neighboring scales.}

\item{mm}{Number of rows of the original input image.}

\item{nn}{Number of columns of the original input image.}

\item{prob}{Credibility level for the posterior credibility analysis}
}
\value{
List with two arrays:
\itemize{
\item \code{pw}: Pointwise probabilities (\code{VmapPW}) including the dimensions
    of the original input image, \code{mm} and \code{nn}.
\item \code{hpw}: Highest pointwise probabilities (\code{VmapHPW}) including
    the dimensions of the original input image, \code{mm} and \code{nn}.
}
}
\description{
Pointwise (PW) probabilities and highest pointwise (HPW) probabilities of
all differences of smooths at neighboring scales are computed.
}
\details{
\code{HPWmap} is an internal function of \code{\link{mrbsizeRgrid}} and is usually
not used independently. The output can be analyzed with the plotting function 
\code{\link{plot.HPWmapGrid}}.
}
\examples{
# Artificial sample data: 10 observations (5-by-2 object), 10 samples
set.seed(987)
sampleData <- matrix(stats::rnorm(100), nrow = 10)
sampleData[4:6, ] <- sampleData[4:6, ] + 5

# Calculation of the simultaneous credible intervals
HPWmap(smoothVec = sampleData, mm = 5, nn = 2, prob = 0.95)

}
