\name{print.hug}
\alias{print.hug}

\title{ Print Huggin's Model objects }

\description{
  Print method for Huggin's closed population model objects 
  estimated by F.huggins.estim().
}
\usage{
\method{print}{hug}(x, ...)
}
\arguments{
  \item{x}{ An object of class "hug" produced by F.huggins.estim()}
  \item{\dots}{ Arguments to other functions called by this one. Currently no other 
		functions are called, so this is not used, but must be here 
		for compatability with the generic \code{print} function.
	    }
}
\value{
  Nothing is returned.  This function is used exclusively for its side effects.  It prints
  an object of class "hug" in a nice human-readable format.  
}
\author{ Trent McDonald, Ph.D., WEST-INC, tmcdonald@west-inc.com  }
\seealso{ \code{\link{F.huggins.estim}} }
\examples{ 

\donttest{
data(dipper.histories)
dipper.fit <- F.huggins.estim( ~1, ~1, dipper.histories )
print(dipper.fit)
}

 }
\keyword{ models }

