\name{place}
\alias{place}
\title{
  Function to place a point on a period-by-period plot generated by \code{\link[mppa]{plot,mproc-method}}
}
\description{
  Places a point at a specified event time on a period-by-period plot generated by \code{\link[mppa]{plot,mproc-method}}.
}
\usage{
place(e, m, period, ...)
}

\arguments{
  \item{e}{the event time - must be within the start and end times of \code{m}.}
  \item{m}{an object of class \code{\linkS4class{mproc}}.}
  \item{period}{the period of the period-by-period plot.}
  \item{\dots}{further arguments passed to \code{points}.}
}
\author{
  Patrick Rubin-Delanchy <patrick.rubin-delanchy@bristol.ac.uk>
}
\seealso{
\code{\link[mppa]{plot,mproc-method}}, \code{\link{mp}}
}
\examples{
#### A has a daily pattern: its intensity is a sinusoidal curve lambda(t) = 1+sin(2*pi*t)
start=0; end=365 #A year
##the cumulative intensity is 
F=function(t){
    t\%/\%1+t\%\%1+(1-cos(2*pi*t\%\%1))/(2*pi)
}
##Dropping 365 A and B points according to F
A=sapply(runif(365), function(u){uniroot(function(x) F(x)/365-u, interval=c(0,365))$root})
m=mp(A,start=start, end=end)
##This plots A in a period by period plot
\dontrun{plot(m, period=1)}
##The middle of the day in the middle of the year:
x=365/2
\dontrun{place(x,m, period=1, col="red", pch=8, cex=10)}
}
\concept{Multiple point processes}
