% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mppData_mdf_pheno.R
\name{mppData_mdf_pheno}
\alias{mppData_mdf_pheno}
\title{Modify the phenotypic values of a mppData object}
\usage{
mppData_mdf_pheno(mppData, pheno)
}
\arguments{
\item{mppData}{An object of class \code{mppData}.}

\item{pheno}{Two columns \code{data.frame} with : 1) \code{character}
genotypes identifiers; 2) \code{numeric} trait values. \strong{The genotypes
identifiers must be identical to \code{mppData$geno.id}. The trait value identifiers
must correspond to a trait already in the mppData object.}}
}
\value{
Return:

\item{mppData}{New \code{mppData} object with modified phenotypic values added.}
}
\description{
Modify the phenotypic values of a \code{mppData} object.
}
\examples{

data(mppData)
pheno_new <- data.frame(geno.id = mppData$geno.id, ULA = rnorm(498))

mppData <- mppData_mdf_pheno(mppData = mppData, pheno = pheno_new)

}
\seealso{
\code{\link{mppData_add_pheno}}, \code{\link{subset.mppData}},
}
\author{
Vincent Garin
}
