% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QTL_forward.R
\name{QTL_forward}
\alias{QTL_forward}
\title{Forward regression QTL model}
\usage{
QTL_forward(
  mppData = NULL,
  trait = 1,
  Q.eff,
  threshold = 4,
  window = 30,
  n.cores = 1,
  verbose = TRUE
)
}
\arguments{
\item{mppData}{An object of class \code{mppData}}

\item{trait}{\code{Numerical} or \code{character} indicator to specify which
trait of the \code{mppData} object should be used. Default = 1.}

\item{Q.eff}{\code{Character} vector of possible QTL effects the user want to
test. Elements of Q.eff can be "cr", "par", "anc" or "biall". For details
look at \code{\link{mpp_SIM}}.}

\item{threshold}{\code{Numeric} value representing the -log10(p-value) threshold
above which a position can be considered as significant. Default = 4.}

\item{window}{\code{Numeric} distance (cM) on the left and the right of a
cofactor position where it is not included in the model. Default = 30.}

\item{n.cores}{\code{Numeric}. Specify here the number of cores you like to
use. Default = 1.}

\item{verbose}{\code{Logical} value indicating if the steps of the
forward regression should be printed. Default = TRUE.}
}
\value{
Return:

\item{QTL }{\code{Data.frame} of class \code{QTLlist} with five columns :
1) QTL marker names; 2) chromosomes;
3) interger position indicators on the chromosome;
4) positions in centi-Morgan; and 5) -log10(p-values).}
}
\description{
Determines a multi-QTL model using a forward regression.
}
\details{
Forward regression to determine the a multi-QTL model. The function
selects successively QTL positions with -log10(pval) above the threshold.
Those positions are added as cofactors for following detection run.
The procedure stop when no more position has a -log10(pval) above the
threshold.
}
\examples{

data(mppData)

QTL <- QTL_forward(mppData = mppData, Q.eff = "par")

}
\seealso{
\code{\link{mpp_SIM}},
}
\author{
Vincent Garin
}
